/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.IJavaDocTagConstants;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentRegion;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContentFormatter2;
import org.eclipse.jface.text.formatter.IFormattingContext;

public class JavaDocRegion
extends MultiCommentRegion
implements IJavaDocTagConstants {
    protected static final String CODE_POSITION_CATEGORY = "__javadoc_code_position";
    private final boolean fFormatHtml;
    private final boolean fFormatSource;

    protected JavaDocRegion(CommentFormattingStrategy strategy, TypedPosition position, String delimiter) {
        super(strategy, position, delimiter);
        Map preferences = strategy.getPreferences();
        this.fFormatSource = "true".equals(preferences.get("comment_format_source_code"));
        this.fFormatHtml = "true".equals(preferences.get("comment_format_html"));
    }

    protected void applyRegion(String indentation, int width) {
        super.applyRegion(indentation, width);
        if (this.fFormatSource) {
            ContentFormatter2 formatter = this.getStrategy().getFormatter();
            try {
                IDocument document = this.getDocument();
                Position[] positions = document.getPositions(CODE_POSITION_CATEGORY);
                if (positions.length > 0) {
                    int begin = 0;
                    int end = 0;
                    CommentFormattingContext context = new CommentFormattingContext();
                    context.setProperty("formatting.context.document", false);
                    context.setProperty("formatting.context.preferences", this.getStrategy().getPreferences());
                    int position = 0;
                    while (position < positions.length - 1) {
                        begin = positions[position++].getOffset();
                        end = positions[position].getOffset();
                        context.setProperty("formatting.context.partition", new TypedPosition(begin, end - begin, "__dftl_partition_content_type"));
                        formatter.format(document, (IFormattingContext)context);
                        ++position;
                    }
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    protected boolean canApply(CommentRange previous, CommentRange next) {
        if (previous != null) {
            boolean isCurrentCode = next.hasAttribute(16);
            boolean isLastCode = previous.hasAttribute(16);
            try {
                int index = this.getOffset();
                IDocument document = this.getDocument();
                if (!isLastCode && isCurrentCode) {
                    document.addPosition(CODE_POSITION_CATEGORY, new Position(index + next.getOffset() + next.getLength()));
                } else if (isLastCode && !isCurrentCode) {
                    document.addPosition(CODE_POSITION_CATEGORY, new Position(index + previous.getOffset()));
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            if (previous.hasAttribute(64) && next.hasAttribute(64) && !isLastCode) {
                return false;
            }
        }
        return true;
    }

    protected void finalizeRegion(String indentation) {
        String test = String.valueOf(indentation) + " * ";
        StringBuffer buffer = new StringBuffer();
        buffer.append(test);
        buffer.append(' ');
        String delimiter = buffer.toString();
        try {
            ConfigurableLineTracker tracker = new ConfigurableLineTracker(new String[]{this.getDelimiter()});
            tracker.set(this.getText(0, this.getLength()));
            int index = 0;
            String content = null;
            IRegion range = null;
            int line = tracker.getNumberOfLines() - 3;
            while (line >= 1) {
                range = tracker.getLineInformation(line);
                index = range.getOffset();
                content = this.getText(index, range.getLength());
                if (!content.startsWith(test)) {
                    this.applyText(delimiter, index, 0);
                }
                --line;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void format(String indentation) {
        DefaultPositionUpdater updater = null;
        IDocument document = this.getDocument();
        if (this.fFormatSource) {
            document.addPositionCategory(CODE_POSITION_CATEGORY);
            updater = new DefaultPositionUpdater(CODE_POSITION_CATEGORY);
            document.addPositionUpdater((IPositionUpdater)updater);
        }
        super.format(indentation);
        if (this.fFormatSource) {
            try {
                document.removePositionCategory(CODE_POSITION_CATEGORY);
                document.removePositionUpdater((IPositionUpdater)updater);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    protected final void markHtmlRanges() {
        this.markTagRanges(IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS, 64, true);
        if (this.fFormatSource) {
            this.markTagRanges(IJavaDocTagConstants.JAVADOC_CODE_TAGS, 16, false);
        }
    }

    protected final void markHtmlTag(CommentRange range, String token) {
        if (range.hasAttribute(32)) {
            range.markHtmlTag(IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS, token, 64, true, true);
            if (this.fFormatHtml) {
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_SEPARATOR_TAGS, token, 4096, true, true);
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_BREAK_TAGS, token, 4, false, true);
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_NEWLINE_TAGS, token, 128, true, false);
            } else {
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_CODE_TAGS, token, 4096, true, true);
            }
        }
    }

    protected final void markJavadocTag(CommentRange range, String token) {
        range.markPrefixTag(IJavaDocTagConstants.JAVADOC_PARAM_TAGS, '@', token, 1024);
        range.markPrefixTag(IJavaDocTagConstants.JAVADOC_ROOT_TAGS, '@', token, 2048);
    }

    protected final void markTagRanges(String[] tags, int key, boolean include) {
        int level = 0;
        int count = 0;
        String token = null;
        CommentRange current = null;
        int index = 0;
        while (index < tags.length) {
            level = 0;
            Iterator iterator = this.getRanges().iterator();
            while (iterator.hasNext()) {
                current = (CommentRange)iterator.next();
                count = current.getLength();
                if (count <= 0) continue;
                token = this.getText(current.getOffset(), current.getLength());
                level = current.markRange(token, tags[index], level, key, include);
            }
            ++index;
        }
    }
}

