/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentObjectFactory;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.IBorderAttributes;
import org.eclipse.jdt.internal.ui.text.comment.ICommentAttributes;
import org.eclipse.jdt.internal.ui.text.comment.IHtmlTagConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public class CommentRegion
extends TypedPosition
implements IHtmlTagConstants,
IBorderAttributes,
ICommentAttributes {
    protected static final String COMMENT_POSITION_CATEGORY = "__comment_position";
    public static final int COMMENT_PREFIX_LENGTH = 3;
    protected static final String COMMENT_RANGE_DELIMITER = " ";
    private int fBorders = 0;
    private final boolean fClear;
    private final String fDelimiter;
    private final IDocument fDocument;
    private final GC fGraphics;
    private final LinkedList fLines = new LinkedList();
    private final LinkedList fRanges = new LinkedList();
    private final boolean fSingleLine;
    private final CommentFormattingStrategy fStrategy;
    private final int fTabs;

    protected CommentRegion(CommentFormattingStrategy strategy, TypedPosition position, String delimiter) {
        super(position.getOffset(), position.getLength(), position.getType());
        this.fStrategy = strategy;
        this.fDelimiter = delimiter;
        this.fClear = "true".equals(this.fStrategy.getPreferences().get("comment_clear_blank_lines"));
        ISourceViewer viewer = strategy.getViewer();
        StyledText text = viewer.getTextWidget();
        this.fDocument = viewer.getDocument();
        if (text != null && !text.isDisposed()) {
            this.fGraphics = new GC((Drawable)text);
            this.fGraphics.setFont(text.getFont());
            this.fTabs = text.getTabs();
        } else {
            this.fGraphics = null;
            this.fTabs = 4;
        }
        ConfigurableLineTracker tracker = new ConfigurableLineTracker(new String[]{delimiter});
        IRegion range = null;
        CommentLine line = null;
        tracker.set(this.getText(0, this.getLength()));
        int lines = tracker.getNumberOfLines();
        this.fSingleLine = lines == 1;
        try {
            int index = 0;
            while (index < lines) {
                range = tracker.getLineInformation(index);
                line = CommentObjectFactory.createLine(this);
                line.append(new CommentRange(range.getOffset(), range.getLength()));
                this.fLines.add(line);
                ++index;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected final void append(CommentRange range) {
        this.fRanges.addLast(range);
    }

    protected void applyRegion(String indentation, int width) {
        int last = this.fLines.size() - 1;
        if (last >= 0) {
            CommentLine previous = null;
            CommentLine next = (CommentLine)this.fLines.get(last);
            CommentRange range = next.getLast();
            next.applyEnd(range, indentation, width);
            int line = last;
            while (line >= 0) {
                previous = next;
                next = (CommentLine)this.fLines.get(line);
                range = next.applyLine(previous, range, indentation, line);
                --line;
            }
            next.applyStart(range, indentation, width);
        }
    }

    protected final void applyText(String change, int position, int count) {
        try {
            int base = this.getOffset() + position;
            String content = this.fDocument.get(base, count);
            if (!change.equals(content)) {
                this.fDocument.replace(this.getOffset() + position, count, change);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int space, int width) {
        return space == 0 || space + next.getLength() < width;
    }

    protected boolean canApply(CommentRange previous, CommentRange next) {
        return true;
    }

    protected void finalizeRegion(String indentation) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void format(String indentation) {
        String probe = this.getText(0, "/*-".length());
        if (probe.startsWith("/*-")) {
            return;
        }
        Map preferences = this.fStrategy.getPreferences();
        int margin = 80;
        try {
            margin = Integer.parseInt(preferences.get("comment_line_length").toString());
        }
        catch (Exception exception) {}
        margin = Math.max(4, margin - this.stringToLength(indentation) - 3);
        this.fDocument.addPositionCategory(COMMENT_POSITION_CATEGORY);
        DefaultPositionUpdater positioner = new DefaultPositionUpdater(COMMENT_POSITION_CATEGORY);
        this.fDocument.addPositionUpdater((IPositionUpdater)positioner);
        try {
            this.initializeRegion();
            this.markRegion();
            this.wrapRegion(margin);
            this.applyRegion(indentation, margin);
            this.finalizeRegion(indentation);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.fGraphics != null && !this.fGraphics.isDisposed()) {
                this.fGraphics.dispose();
            }
            try {
                this.fDocument.removePositionCategory(COMMENT_POSITION_CATEGORY);
                this.fDocument.removePositionUpdater((IPositionUpdater)positioner);
                throw throwable;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        if (this.fGraphics != null && !this.fGraphics.isDisposed()) {
            this.fGraphics.dispose();
        }
        try {}
        catch (BadPositionCategoryException badPositionCategoryException) {
            return;
        }
        this.fDocument.removePositionCategory(COMMENT_POSITION_CATEGORY);
        this.fDocument.removePositionUpdater((IPositionUpdater)positioner);
    }

    protected final String getDelimiter() {
        return this.fDelimiter;
    }

    protected String getDelimiter(CommentLine predecessor, CommentLine successor, CommentRange previous, CommentRange next, String indentation) {
        return String.valueOf(this.fDelimiter) + indentation + successor.getContentPrefix();
    }

    protected String getDelimiter(CommentRange previous, CommentRange next) {
        return COMMENT_RANGE_DELIMITER;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    protected final LinkedList getRanges() {
        return this.fRanges;
    }

    protected final int getSize() {
        return this.fLines.size();
    }

    protected final CommentFormattingStrategy getStrategy() {
        return this.fStrategy;
    }

    protected final String getText(int position, int count) {
        String content = "";
        try {
            content = this.fDocument.get(this.getOffset() + position, count);
        }
        catch (BadLocationException badLocationException) {}
        return content;
    }

    protected final boolean hasBorder(int border) {
        return (this.fBorders & border) == border;
    }

    protected void initializeRegion() {
        try {
            this.fDocument.addPosition(COMMENT_POSITION_CATEGORY, (Position)this);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        int index = 0;
        CommentLine line = null;
        Iterator iterator = this.fLines.iterator();
        while (iterator.hasNext()) {
            line = (CommentLine)iterator.next();
            line.scanLine(index);
            line.tokenizeLine(index);
            ++index;
        }
    }

    protected final boolean isClearLines() {
        return this.fClear;
    }

    protected final boolean isCommentWord(CommentRange current) {
        String token = this.getText(current.getOffset(), current.getLength());
        int index = 0;
        while (index < token.length()) {
            if (!Character.isLetterOrDigit(token.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected final boolean isSingleLine() {
        return this.fSingleLine;
    }

    protected void markRegion() {
    }

    protected final void setBorder(int border) {
        this.fBorders |= border;
    }

    protected final String stringToIndent(String reference, boolean tabs) {
        int space = 1;
        int pixels = reference.length();
        if (this.fGraphics != null) {
            pixels = this.stringToPixels(reference);
            space = this.fGraphics.stringExtent((String)COMMENT_RANGE_DELIMITER).x;
        }
        StringBuffer buffer = new StringBuffer();
        int spaces = pixels / space;
        if (tabs) {
            int count = spaces / this.fTabs;
            int modulo = spaces % this.fTabs;
            int index = 0;
            while (index < count) {
                buffer.append('\t');
                ++index;
            }
            index = 0;
            while (index < modulo) {
                buffer.append(' ');
                ++index;
            }
        } else {
            int index = 0;
            while (index < spaces) {
                buffer.append(' ');
                ++index;
            }
        }
        return buffer.toString();
    }

    protected final int stringToLength(String reference) {
        int tabs = 0;
        int count = reference.length();
        int index = 0;
        while (index < count) {
            if (reference.charAt(index) == '\t') {
                ++tabs;
            }
            ++index;
        }
        return count += tabs * (this.fTabs - 1);
    }

    protected final int stringToPixels(String reference) {
        StringBuffer buffer = new StringBuffer();
        char character = '\u0000';
        int index = 0;
        while (index < reference.length()) {
            character = reference.charAt(index);
            if (character == '\t') {
                int tab = 0;
                while (tab < this.fTabs) {
                    buffer.append(' ');
                    ++tab;
                }
            } else {
                buffer.append(character);
            }
            ++index;
        }
        return this.fGraphics.stringExtent((String)buffer.toString()).x;
    }

    protected void wrapRegion(int width) {
        this.fLines.clear();
        int index = 0;
        boolean adapted = false;
        CommentLine successor = null;
        CommentLine predecessor = null;
        CommentRange previous = null;
        CommentRange next = null;
        block0: while (!this.fRanges.isEmpty()) {
            index = 0;
            adapted = false;
            predecessor = successor;
            successor = CommentObjectFactory.createLine(this);
            this.fLines.add(successor);
            while (!this.fRanges.isEmpty()) {
                next = (CommentRange)this.fRanges.getFirst();
                if (!this.canAppend(successor, previous, next, index, width)) continue block0;
                if (!adapted && predecessor != null) {
                    successor.adapt(predecessor);
                    adapted = true;
                }
                this.fRanges.removeFirst();
                successor.append(next);
                index += next.getLength() + 1;
                previous = next;
            }
        }
    }
}

