/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import org.eclipse.jdt.internal.ui.text.comment.ICommentAttributes;
import org.eclipse.jdt.internal.ui.text.comment.IHtmlTagConstants;
import org.eclipse.jface.text.Position;

public class CommentRange
extends Position
implements ICommentAttributes,
IHtmlTagConstants {
    private int fAttributes = 0;

    public CommentRange(int position, int count) {
        super(position, count);
    }

    protected final boolean hasAttribute(int attribute) {
        return (this.fAttributes & attribute) == attribute;
    }

    protected final boolean isClosingTag(String token, String tag) {
        boolean result;
        boolean bl = result = token.startsWith("</") && token.charAt(token.length() - 1) == '>';
        if (result) {
            this.setAttribute(8);
            result = token.substring("</".length(), token.length() - 1).equals(tag);
        }
        return result;
    }

    protected final boolean isOpeningTag(String token, String tag) {
        boolean result;
        boolean bl = result = token.charAt(0) == '<' && !token.startsWith("</") && token.charAt(token.length() - 1) == '>';
        if (result) {
            this.setAttribute(256);
            result = token.startsWith(tag, 1);
        }
        return result;
    }

    protected final void markHtmlTag(String[] tags, String token, int attribute, boolean open, boolean close) {
        if (token.charAt(0) == '<' && token.charAt(token.length() - 1) == '>') {
            String tag = null;
            boolean isOpen = false;
            boolean isClose = false;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                isOpen = this.isOpeningTag(token, tag);
                isClose = this.isClosingTag(token, tag);
                if (open && isOpen || close && isClose) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final void markPrefixTag(String[] tags, char prefix, String token, int attribute) {
        if (token.charAt(0) == prefix) {
            String tag = null;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                if (token.equals(tag)) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final int markRange(String token, String tag, int level, int key, boolean html) {
        if (this.isOpeningTag(token, tag)) {
            if (level++ > 0) {
                this.setAttribute(key);
            }
        } else if (this.isClosingTag(token, tag)) {
            if (--level > 0) {
                this.setAttribute(key);
            }
        } else if (level > 0 && (html || !this.hasAttribute(32))) {
            this.setAttribute(key);
        }
        return level;
    }

    public final void move(int delta) {
        this.offset += delta;
    }

    protected final void setAttribute(int attribute) {
        this.fAttributes |= attribute;
    }

    public final void trimBegin(int delta) {
        this.offset += delta;
        this.length -= delta;
    }

    public final void trimEnd(int delta) {
        this.length += delta;
    }
}

