/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.JavaDocLine;
import org.eclipse.jdt.internal.ui.text.comment.JavaDocRegion;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentLine;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.SingleCommentLine;
import org.eclipse.jface.text.TypedPosition;

public class CommentObjectFactory {
    public static CommentLine createLine(CommentRegion region) {
        String type = region.getType();
        if (type.equals("__java_javadoc")) {
            return new JavaDocLine(region);
        }
        if (type.equals("__java_multiline_comment")) {
            return new MultiCommentLine(region);
        }
        if (type.equals("__java_singleline_comment")) {
            return new SingleCommentLine(region);
        }
        return null;
    }

    public static CommentRegion createRegion(CommentFormattingStrategy strategy, TypedPosition range, String delimiter) {
        String type = range.getType();
        if (type.equals("__java_javadoc")) {
            return new JavaDocRegion(strategy, range, delimiter);
        }
        if (type.equals("__java_multiline_comment")) {
            return new MultiCommentRegion(strategy, range, delimiter);
        }
        return new CommentRegion(strategy, range, delimiter);
    }

    private CommentObjectFactory() {
    }
}

