/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.comment.CommentObjectFactory;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContentFormatter2;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final ContentFormatter2 fFormatter;
    private final LinkedList fPartitions = new LinkedList();

    public static String getLineIndentation(IDocument document, CommentRegion region, int offset) {
        String result = "";
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            int begin = line.getOffset();
            int end = Math.min(offset, line.getOffset() + line.getLength());
            boolean useTab = "tab".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"));
            result = region.stringToIndent(document.get(begin, end - begin), useTab);
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public CommentFormattingStrategy(ContentFormatter2 formatter, ISourceViewer viewer) {
        super(viewer);
        this.fFormatter = formatter;
    }

    public void format() {
        super.format();
        Assert.isLegal((this.fPartitions.size() > 0 ? 1 : 0) != 0);
        IDocument document = this.getViewer().getDocument();
        TypedPosition position = (TypedPosition)this.fPartitions.removeFirst();
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fFormatter.getDocumentPartitioning(), (int)position.getOffset());
            String type = partition.getType();
            position.offset = partition.getOffset();
            position.length = partition.getLength();
            Map preferences = this.getPreferences();
            boolean format = "true".equals(preferences.get("comment_format_comments"));
            boolean header = "true".equals(preferences.get("comment_format_header"));
            if (format && (header || position.getOffset() != 0 || !type.equals("__java_javadoc"))) {
                CommentRegion region = CommentObjectFactory.createRegion(this, position, TextUtilities.getDefaultLineDelimiter((IDocument)document));
                String indentation = CommentFormattingStrategy.getLineIndentation(document, region, position.getOffset());
                region.format(indentation);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        FormattingContext current = (FormattingContext)context;
        this.fPartitions.addLast(current.getProperty((Object)"formatting.context.partition"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
    }

    public final ContentFormatter2 getFormatter() {
        return this.fFormatter;
    }
}

