/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class JavaOutlineInformationControl
extends AbstractInformationControl {
    public JavaOutlineInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle);
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        tree.setLayoutData((Object)new GridData(1808));
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IImportDeclaration);
            }
        });
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        treeViewer.addFilter(new MemberFilter());
        treeViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider(true, true));
        treeViewer.setSorter(new JavaElementSorter());
        treeViewer.setAutoExpandLevel(-1);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(1090519561, 1);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(lprovider));
        return treeViewer;
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement je = (IJavaElement)information;
        Object sel = null;
        ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
        sel = cu != null ? cu : je.getAncestor(6);
        this.inputChanged(sel, information);
    }

    public class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering = false;

        public OutlineTreeViewer(Tree tree) {
            super(tree);
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    result = filters[i].filter((Viewer)this, parent, result);
                    ++i;
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IJavaElement je;
            Item i;
            if (!this.fIsFiltering && node instanceof Item && (i = (Item)node).getData() instanceof IJavaElement && ((je = (IJavaElement)i.getData()).getElementType() == 12 || this.isInnerType(je))) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        private boolean isInnerType(IJavaElement element) {
            block3: {
                if (element != null && element.getElementType() == 7) {
                    IType type = (IType)element;
                    try {
                        return type.isMember();
                    }
                    catch (JavaModelException javaModelException) {
                        IJavaElement parent = type.getParent();
                        if (parent == null) break block3;
                        int parentElementType = parent.getElementType();
                        return parentElementType != 5 && parentElementType != 6;
                    }
                }
            }
            return false;
        }
    }
}

