/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class JavaIndenter {
    private IDocument fDocument;
    private int fIndent;
    private int fAlign;
    private int fPosition;
    private int fPreviousPos;
    private int fToken;
    private int fLine;
    private JavaHeuristicScanner fScanner;

    public JavaIndenter(IDocument document, JavaHeuristicScanner scanner) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)scanner);
        this.fDocument = document;
        this.fScanner = scanner;
    }

    public StringBuffer getReferenceIndentation(int offset) {
        int unit = this.findReferencePosition(offset, true);
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public StringBuffer computeIndentation(int offset) {
        StringBuffer indent = this.getReferenceIndentation(offset);
        if (this.fAlign != -1) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(this.fAlign);
                int lineOffset = line.getOffset();
                return this.createIndent(lineOffset, this.fAlign);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (indent == null) {
            return null;
        }
        indent.append((Object)this.createIndent(this.fIndent));
        if (this.fIndent < 0) {
            this.unindent(indent);
        }
        return indent;
    }

    private StringBuffer getLeadingWhitespace(int offset) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            indent.append(this.fDocument.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    private void unindent(StringBuffer indent) {
        CharSequence oneIndent = this.createIndent(1);
        int i = indent.lastIndexOf(oneIndent.toString());
        if (i != -1) {
            indent.delete(i, i + oneIndent.length());
        }
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer createIndent(int start, int indent) {
        block9: {
            tabLen = this.prefTabLength();
            ret = new StringBuffer();
            try {
                spaces = 0;
                while (start < indent) {
                    ch = this.fDocument.getChar(start);
                    if (ch == '\t') {
                        ret.append('\t');
                        spaces = 0;
                    } else if (tabLen == -1) {
                        ret.append(' ');
                    } else if (++spaces == tabLen) {
                        ret.append('\t');
                        spaces = 0;
                    }
                    ++start;
                }
                if (spaces != tabLen) ** GOTO lbl28
                ret.append('\t');
                break block9;
lbl-1000:
                // 1 sources

                {
                    ret.append(' ');
lbl28:
                    // 2 sources

                    ** while (spaces-- > 0)
                }
lbl29:
                // 1 sources

            }
            catch (BadLocationException v0) {}
        }
        return ret;
    }

    private CharSequence createIndent(int indent) {
        int i;
        JavaCore plugin = JavaCore.getJavaCore();
        if (plugin == null) {
            StringBuffer ret = new StringBuffer();
            while (indent-- > 0) {
                ret.append('\t');
            }
            return ret;
        }
        StringBuffer oneIndent = new StringBuffer();
        if ("space".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"))) {
            int tabLen = Integer.parseInt(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.size"));
            i = 0;
            while (i < tabLen) {
                oneIndent.append(' ');
                ++i;
            }
        } else if ("tab".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"))) {
            oneIndent.append('\t');
        } else {
            oneIndent.append('\t');
        }
        StringBuffer ret = new StringBuffer();
        i = 0;
        while (i < indent) {
            ret.append(oneIndent);
            ++i;
        }
        return ret;
    }

    public int findReferencePosition(int offset) {
        return this.findReferencePosition(offset, false);
    }

    public int findReferencePosition(int offset, boolean peekNextChar) {
        boolean danglingElse = false;
        boolean unindent = false;
        boolean matchBrace = false;
        boolean matchParen = false;
        boolean matchCase = false;
        if (peekNextChar) {
            if (offset < this.fDocument.getLength()) {
                try {
                    IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                    int lineOffset = line.getOffset();
                    int next = this.fScanner.nextToken(offset, lineOffset + line.getLength());
                    int prevPos = Math.max(offset - 1, 0);
                    boolean isFirstTokenOnLine = this.fDocument.get(lineOffset, prevPos + 1 - lineOffset).trim().length() == 0;
                    switch (next) {
                        case -1: 
                        case 1014: {
                            danglingElse = true;
                            break;
                        }
                        case 1013: 
                        case 1024: {
                            if (!isFirstTokenOnLine) break;
                            matchCase = true;
                            break;
                        }
                        case 1: {
                            if (this.fScanner.isBracelessBlockStart(prevPos, -2)) {
                                unindent = true;
                            }
                            if (this.fScanner.previousToken(prevPos, -2) != 9) break;
                            unindent = true;
                            break;
                        }
                        case 2: {
                            if (!isFirstTokenOnLine) break;
                            matchBrace = true;
                            break;
                        }
                        case 6: {
                            if (!isFirstTokenOnLine) break;
                            matchParen = true;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                danglingElse = true;
            }
        }
        int ref = this.findReferencePosition(offset, danglingElse, matchBrace, matchParen, matchCase);
        if (unindent) {
            --this.fIndent;
        }
        return ref;
    }

    public int findReferencePosition(int offset, boolean danglingElse, boolean matchBrace, boolean matchParen, boolean matchCase) {
        this.fIndent = 0;
        this.fAlign = -1;
        this.fPosition = offset;
        if (matchBrace) {
            if (this.skipScope(1, 2)) {
                return this.skipToStatementStart(true, true);
            }
            int pos = this.findReferencePosition(offset, danglingElse, false, matchParen, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchParen) {
            if (this.skipScope(5, 6)) {
                return this.fPosition;
            }
            int pos = this.findReferencePosition(offset, danglingElse, matchBrace, false, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchCase) {
            return this.matchCaseAlignment();
        }
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                int pos = this.fPosition;
                if (!this.skipScope()) {
                    this.fPosition = pos;
                }
            }
            case 7: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 1: 
            case 3: 
            case 5: {
                return this.handleScopeIntroduction(offset + 1);
            }
            case -1: {
                return 0;
            }
            case 12: {
                this.fIndent = this.prefAssignmentIndent();
                return this.fPosition;
            }
            case 9: {
                this.fIndent = this.prefCaseBlockIndent();
                return this.fPosition;
            }
            case 10: {
                if (this.prefTernaryDeepAlign()) {
                    this.setFirstElementAlignment(this.fPosition, offset + 1);
                    return this.fPosition;
                }
                this.fIndent = this.prefTernaryIndent();
                return this.fPosition;
            }
            case 1010: 
            case 1014: 
            case 1017: {
                this.fIndent = this.prefSimpleIndent();
                return this.fPosition;
            }
            case 6: {
                if (!this.skipScope(5, 6)) break;
                this.nextToken();
                if (this.fToken != 109 && this.fToken != 1017 && this.fToken != 1011) break;
                this.fIndent = this.prefSimpleIndent();
                return this.fPosition;
            }
        }
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToStatementStart(boolean danglingElse, boolean isInBlock) {
        block13: while (true) {
            this.nextToken();
            if (isInBlock) {
                switch (this.fToken) {
                    case 9: 
                    case 109: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1014: 
                    case 1016: 
                    case 1017: 
                    case 1019: 
                    case 1021: 
                    case 1022: {
                        return this.fPosition;
                    }
                    case 1020: {
                        this.fIndent = this.prefCaseIndent();
                        return this.fPosition;
                    }
                }
            }
            switch (this.fToken) {
                case -1: 
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    return this.fPreviousPos;
                }
                case 2: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope() && this.looksLikeArrayInitializerIntro()) continue block13;
                    return pos;
                }
                case 4: 
                case 6: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope()) continue block13;
                    return pos;
                }
                case 109: {
                    if (!danglingElse) break;
                    return this.fPosition;
                }
                case 1014: {
                    int pos = this.fPosition;
                    if (this.skipNextIF()) continue block13;
                    return pos;
                }
                case 1010: {
                    return this.fPosition;
                }
                case 1017: {
                    int pos = this.fPosition;
                    if (this.hasMatchingDo()) continue block13;
                    this.fPosition = pos;
                }
            }
        }
    }

    private int matchCaseAlignment() {
        while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1: {
                    this.fIndent = this.prefCaseIndent();
                    return this.fPosition;
                }
                case 1013: 
                case 1024: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    break;
                }
            }
        }
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.fLine;
        int startPosition = this.fPosition;
        while (true) {
            this.nextToken();
            if (this.fLine < startLine) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(startLine);
                    this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, startPosition + 1);
                }
                catch (BadLocationException badLocationException) {}
                return startPosition;
            }
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    return this.handleScopeIntroduction(startPosition + 1);
                }
                case 7: {
                    return this.fPosition;
                }
                case -1: {
                    return 0;
                }
            }
        }
    }

    private boolean skipScope() {
        switch (this.fToken) {
            case 6: {
                return this.skipScope(5, 6);
            }
            case 4: {
                return this.skipScope(3, 4);
            }
            case 2: {
                return this.skipScope(1, 2);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private int handleScopeIntroduction(int bound) {
        switch (this.fToken) {
            case 5: {
                int pos = this.fPosition;
                if (this.looksLikeMethodDecl()) {
                    if (this.prefMethodDeclDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefMethodDeclIndent();
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeMethodCall()) {
                    if (this.prefMethodCallDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefMethodCallIndent();
                    return pos;
                }
                if (this.prefParenthesisDeepIndent()) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.prefParenthesisIndent();
                return pos;
            }
            case 1: {
                int pos = this.fPosition;
                if (this.looksLikeArrayInitializerIntro()) {
                    if (this.prefArrayDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefArrayIndent();
                } else {
                    this.fIndent = this.prefBlockIndent();
                }
                this.fPosition = pos;
                return this.skipToStatementStart(true, true);
            }
            case 3: {
                int pos = this.fPosition;
                if (this.prefArrayDimensionsDeepIndent()) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.prefBracketIndent();
                return pos;
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private int setFirstElementAlignment(int scopeIntroducerOffset, int bound) {
        int firstPossible = scopeIntroducerOffset + 1;
        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(firstPossible, bound);
        if (this.fAlign == -1) {
            this.fAlign = firstPossible;
        }
        return this.fAlign;
    }

    private boolean looksLikeArrayInitializerIntro() {
        this.nextToken();
        return this.fToken == 12 || this.skipBrackets();
    }

    private boolean skipNextIF() {
        Assert.isTrue((this.fToken == 1014 ? 1 : 0) != 0);
        while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    break;
                }
                case 109: {
                    return true;
                }
                case 1014: {
                    this.skipNextIF();
                    break;
                }
                case -1: 
                case 1: 
                case 3: 
                case 5: {
                    return false;
                }
            }
        }
    }

    private boolean hasMatchingDo() {
        Assert.isTrue((this.fToken == 1017 ? 1 : 0) != 0);
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                this.skipScope();
            }
            case 7: {
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
        }
        return false;
    }

    private boolean skipBrackets() {
        if (this.fToken == 4) {
            this.nextToken();
            if (this.fToken == 3) {
                return true;
            }
        }
        return false;
    }

    private void nextToken() {
        this.nextToken(this.fPosition);
    }

    private void nextToken(int start) {
        this.fToken = this.fScanner.previousToken(start - 1, -2);
        this.fPreviousPos = start;
        this.fPosition = this.fScanner.getPosition() + 1;
        try {
            this.fLine = this.fDocument.getLineOfOffset(this.fPosition);
        }
        catch (BadLocationException badLocationException) {
            this.fLine = -1;
        }
    }

    private boolean looksLikeMethodDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            do {
                this.nextToken();
            } while (this.skipBrackets());
            return this.fToken == 2000;
        }
        return false;
    }

    private boolean looksLikeMethodCall() {
        this.nextToken();
        return this.fToken == 2000;
    }

    private boolean skipScope(int openToken, int closeToken) {
        int depth = 1;
        while (true) {
            this.nextToken();
            if (this.fToken == closeToken) {
                ++depth;
                continue;
            }
            if (this.fToken == openToken) {
                if (--depth != 0) continue;
                return true;
            }
            if (this.fToken == -1) break;
        }
        return false;
    }

    private int prefTabLength() {
        JavaCore core = JavaCore.getJavaCore();
        JavaPlugin plugin = JavaPlugin.getDefault();
        int tabLen = core != null ? ("space".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char")) ? -1 : plugin.getPreferenceStore().getInt("org.eclipse.jdt.ui.editor.tab.width")) : 4;
        return tabLen;
    }

    private boolean prefArrayDimensionsDeepIndent() {
        return true;
    }

    private int prefArrayIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.array_initializer_expressions_alignment");
            try {
                if ((Integer.parseInt(option) & Integer.parseInt("4")) != 0) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.prefContinuationIndent();
    }

    private boolean prefArrayDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.array_initializer_expressions_alignment");
            try {
                return (Integer.parseInt(option) & Integer.parseInt("2")) != 0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return true;
    }

    private boolean prefTernaryDeepAlign() {
        return true;
    }

    private int prefTernaryIndent() {
        return 2;
    }

    private int prefCaseIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            if ("true".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch"))) {
                return 0;
            }
            return this.prefBlockIndent();
        }
        return 0;
    }

    private int prefAssignmentIndent() {
        return this.prefBlockIndent();
    }

    private int prefCaseBlockIndent() {
        return this.prefBlockIndent();
    }

    private int prefSimpleIndent() {
        return this.prefBlockIndent();
    }

    private int prefBracketIndent() {
        return this.prefBlockIndent();
    }

    private boolean prefMethodDeclDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.method_declaration_arguments_alignment");
            try {
                return (Integer.parseInt(option) & Integer.parseInt("2")) != 0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return true;
    }

    private int prefMethodDeclIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.method_declaration_arguments_alignment");
            try {
                if ((Integer.parseInt(option) & Integer.parseInt("4")) != 0) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1;
    }

    private boolean prefMethodCallDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.message_send_arguments_alignment");
            try {
                return (Integer.parseInt(option) & Integer.parseInt("2")) != 0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    private int prefMethodCallIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.message_send_arguments_alignment");
            try {
                if ((Integer.parseInt(option) & Integer.parseInt("4")) != 0) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1;
    }

    private boolean prefParenthesisDeepIndent() {
        return false;
    }

    private int prefParenthesisIndent() {
        return this.prefContinuationIndent();
    }

    private int prefBlockIndent() {
        return 1;
    }

    private int prefContinuationIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.continuation_indentation");
            try {
                return Integer.parseInt(option);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 2;
    }
}

