/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Arrays;
import org.eclipse.jdt.internal.ui.text.Symbols;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class JavaHeuristicScanner
implements Symbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private IDocument fDocument;
    private String fPartitioning;
    private String fPartition;
    private char fChar;
    private int fPos;
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();

    public JavaHeuristicScanner(IDocument document, String partitioning, String partition) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)partitioning);
        Assert.isNotNull((Object)partition);
        this.fDocument = document;
        this.fPartitioning = partitioning;
        this.fPartition = partition;
    }

    public JavaHeuristicScanner(IDocument document) {
        this(document, "___java_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this.fNonIdent)) == -1 ? bound : pos;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this.fNonIdent)) == -1 ? bound + 1 : pos + 1;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    private int getToken(String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 2: {
                if ("if".equals(s)) {
                    return 109;
                }
                if (!"do".equals(s)) break;
                return 1010;
            }
            case 3: {
                if ("for".equals(s)) {
                    return 1011;
                }
                if ("try".equals(s)) {
                    return 1012;
                }
                if (!"new".equals(s)) break;
                return 1025;
            }
            case 4: {
                if ("case".equals(s)) {
                    return 1013;
                }
                if ("else".equals(s)) {
                    return 1014;
                }
                if (!"goto".equals(s)) break;
                return 1023;
            }
            case 5: {
                if ("break".equals(s)) {
                    return 1015;
                }
                if ("catch".equals(s)) {
                    return 1016;
                }
                if (!"while".equals(s)) break;
                return 1017;
            }
            case 6: {
                if ("return".equals(s)) {
                    return 1018;
                }
                if ("static".equals(s)) {
                    return 1019;
                }
                if (!"switch".equals(s)) break;
                return 1020;
            }
            case 7: {
                if ("default".equals(s)) {
                    return 1024;
                }
                if (!"finally".equals(s)) break;
                return 1021;
            }
            case 12: {
                if (!"synchronized".equals(s)) break;
                return 1022;
            }
        }
        return 2000;
    }

    public int findClosingPeer(int start, char openingPeer, char closingPeer) {
        Assert.isNotNull((Object)this.fDocument);
        Assert.isTrue((start >= 0 ? 1 : 0) != 0);
        try {
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == openingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int findOpeningPeer(int start, char openingPeer, char closingPeer) {
        Assert.isTrue((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == closingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findSurroundingBlock(int offset) {
        if (offset < 1 || offset >= this.fDocument.getLength()) {
            return null;
        }
        int begin = this.findOpeningPeer(offset - 1, '{', '}');
        int end = this.findClosingPeer(offset, '{', '}');
        if (begin == -1 || end == -1) {
            return null;
        }
        return new Region(begin, end + 1 - begin);
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, fNonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isTrue((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isTrue((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                ++this.fPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    public int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatch(chars));
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        Assert.isTrue((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos > bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                --this.fPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new CharacterMatch(ch));
    }

    public int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatch(chars));
    }

    public boolean isDefaultPartition(int position) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)position);
            return region.getType().equals(this.fPartition);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public boolean isBracelessBlockStart(int position, int bound) {
        if (position < 1) {
            return false;
        }
        switch (this.previousToken(position, bound)) {
            case 1010: 
            case 1014: {
                return true;
            }
            case 6: {
                position = this.findOpeningPeer(this.fPos, '(', ')');
                if (position <= 0) break;
                switch (this.previousToken(position - 1, bound)) {
                    case 109: 
                    case 1011: 
                    case 1017: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public interface StopCondition {
        public boolean stop(char var1, int var2, boolean var3);
    }

    private static class NonWhitespace
    implements StopCondition {
        NonWhitespace() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }
    }

    private class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        NonWhitespaceDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && JavaHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private static class NonJavaIdentifierPart
    implements StopCondition {
        NonJavaIdentifierPart() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        NonJavaIdentifierPartDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !JavaHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private class CharacterMatch
    implements StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && JavaHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    protected class SkippingScopeMatch
    extends CharacterMatch {
        private char fOpening;
        private char fClosing;
        private int fDepth = 0;

        public SkippingScopeMatch(char ch) {
            super(ch);
        }

        public SkippingScopeMatch(char[] chars) {
            super(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            if (this.fDepth == 0 && super.stop(ch, position, true)) {
                return true;
            }
            if (ch == this.fOpening) {
                ++this.fDepth;
            } else if (ch == this.fClosing) {
                --this.fDepth;
                if (this.fDepth == 0) {
                    this.fOpening = '\u0000';
                    this.fClosing = '\u0000';
                }
            } else if (this.fDepth == 0) {
                this.fDepth = 1;
                if (forward) {
                    switch (ch) {
                        case '{': {
                            this.fOpening = (char)123;
                            this.fClosing = (char)125;
                            break;
                        }
                        case '(': {
                            this.fOpening = (char)40;
                            this.fClosing = (char)41;
                            break;
                        }
                        case '[': {
                            this.fOpening = (char)91;
                            this.fClosing = (char)93;
                        }
                    }
                } else {
                    switch (ch) {
                        case '}': {
                            this.fOpening = (char)125;
                            this.fClosing = (char)123;
                            break;
                        }
                        case ')': {
                            this.fOpening = (char)41;
                            this.fClosing = (char)40;
                            break;
                        }
                        case ']': {
                            this.fOpening = (char)93;
                            this.fClosing = (char)91;
                        }
                    }
                }
            }
            return false;
        }
    }
}

