/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private static final int BORDER = 1;
    private static final int RIGHT_MARGIN = 3;
    private Shell fShell;
    Composite fComposite;
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private StringMatcher fStringMatcher;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this.fShell = new Shell(parent, shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(768));
        this.createFilterText(this.fComposite);
        this.fTreeViewer = this.createTreeViewer(this.fComposite, treeStyle);
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        int border = (shellStyle & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(border));
        this.setInfoSystemColor();
        this.installFilter();
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0x800000);
        GridData data = new GridData();
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
        return this.fFilterText;
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractInformationControl.this.setMatcherString(text);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        this.stringMatcherUpdated();
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                OpenActionUtil.open(selectedElement, true);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
            }
        }
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        IJavaElement element = this.findElement(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private IJavaElement findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            IJavaElement element = (IJavaElement)items[i].getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText((Object)element))) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(newInput);
        if (newSelection != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fTreeViewer = null;
            this.fComposite = null;
            this.fFilterText = null;
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fComposite.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fTreeViewer.getTree().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fTreeViewer.getTree().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fShell.removeFocusListener(listener);
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null && matcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof IParent) {
                Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select((Viewer)viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }
}

