/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class OccurrencesFinder
extends ASTVisitor {
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();

    public OccurrencesFinder(IBinding target) {
        this.fTarget = target;
    }

    public List getUsages() {
        return this.fUsages;
    }

    public List getWriteUsages() {
        return this.fWriteUsages;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            SimpleName name = node.getName();
            return !this.match((Name)name, this.fUsages, name.resolveBinding());
        }
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(SimpleName node) {
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(ClassInstanceCreation node) {
        Name name = node.getName();
        if (name instanceof QualifiedName) {
            name = ((QualifiedName)name).getName();
        }
        this.match(name, this.fUsages, (IBinding)node.resolveConstructorBinding());
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Name name = this.getName(lhs);
        if (name != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        lhs.accept((ASTVisitor)this);
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        Expression operand;
        Name name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getName(operand = node.getOperand())) != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        Name name = this.getName(operand);
        if (name != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    private boolean match(Name node, List result, IBinding binding) {
        if (binding != null && Bindings.equals(binding, this.fTarget)) {
            result.add(node);
            return true;
        }
        return false;
    }

    private Name getName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return (QualifiedName)expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }
}

