/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;

public abstract class JavaSearchSorter
extends ViewerSorter {
    private Map fLabelCache = new HashMap();
    protected ILabelProvider fLabelProvider;

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }

    protected String getLabel(Object element) {
        String label = (String)this.fLabelCache.get(element);
        if (label != null) {
            return label;
        }
        return this.fLabelProvider.getText(element);
    }

    protected boolean setupLabelProvider() {
        ISearchResultView view = SearchUI.getSearchResultView();
        if (view == null) {
            return false;
        }
        this.fLabelProvider = view.getLabelProvider();
        if (this.fLabelProvider instanceof JavaSearchResultLabelProvider) {
            ((JavaSearchResultLabelProvider)this.fLabelProvider).setOrder(this.getSortOrder());
            return true;
        }
        return false;
    }

    protected abstract int getSortOrder();

    public void sort(Viewer viewer, Object[] elements) {
        if (!this.setupLabelProvider()) {
            return;
        }
        this.cacheLabels(elements);
        super.sort(viewer, elements);
        this.fLabelCache.clear();
    }

    private void cacheLabels(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            String label = this.fLabelProvider.getText(elements[i]);
            if (label != null) {
                this.fLabelCache.put(elements[i], label);
            }
            ++i;
        }
    }
}

