/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class GotoMarkerAction
extends Action {
    private IEditorPart fEditor;

    public GotoMarkerAction() {
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.goto_marker_action");
    }

    public void run() {
        ISearchResultView view = SearchUI.getSearchResultView();
        Object element = SelectionUtil.getSingleElement(view.getSelection());
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
            this.show(entry.getSelectedMarker());
        }
    }

    private void show(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource == null || !resource.exists()) {
            return;
        }
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        IJavaElement javaElement = SearchUtil.getJavaElement(marker);
        if (javaElement != null && javaElement.getElementType() == 4) {
            this.gotoPackagesView(javaElement, wbPage);
        } else if (SearchUI.reuseEditor()) {
            this.showWithReuse(marker, resource, javaElement, wbPage);
        } else {
            this.showWithoutReuse(marker, javaElement, wbPage);
        }
    }

    private void showWithoutReuse(IMarker marker, IJavaElement javaElement, IWorkbenchPage wbPage) {
        IEditorPart editor = null;
        try {
            IJavaElement objectToOpen = javaElement;
            if (objectToOpen == null) {
                objectToOpen = marker.getResource();
            }
            editor = EditorUtility.openInEditor(objectToOpen, false);
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.getString("Search.Error.openEditor.title"), (String)SearchMessages.getString("Search.Error.openEditor.message"));
        }
        if (editor != null) {
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
    }

    private void showWithReuse(IMarker marker, IResource resource, IJavaElement javaElement, IWorkbenchPage wbPage) {
        if (javaElement == null || !this.isBinary(javaElement)) {
            if (resource instanceof IFile) {
                this.showInEditor(marker, wbPage, (IEditorInput)new FileEditorInput((IFile)resource), "org.eclipse.jdt.ui.CompilationUnitEditor");
            }
        } else {
            IClassFile cf = this.getClassFile(javaElement);
            if (cf != null) {
                this.showInEditor(marker, wbPage, new InternalClassFileEditorInput(cf), "org.eclipse.jdt.ui.ClassFileEditor");
            }
        }
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private void showInEditor(IMarker marker, IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput(input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
            } else {
                try {
                    editor = page.openEditor(input, editorId, false);
                    this.fEditor = editor instanceof IReusableEditor ? editor : null;
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.getString("Search.Error.openEditor.title"), (String)SearchMessages.getString("Search.Error.openEditor.message"));
                    return;
                }
            }
        }
        if (editor != null) {
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
    }

    private void gotoPackagesView(IJavaElement javaElement, IWorkbenchPage wbPage) {
        try {
            IViewPart view = wbPage.showView("org.eclipse.jdt.ui.PackageExplorer");
            if (view instanceof IPackagesViewPart) {
                ((IPackagesViewPart)view).selectAndReveal(javaElement);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.getString("Search.Error.openEditor.title"), (String)SearchMessages.getString("Search.Error.openEditor.message"));
        }
    }

    private IClassFile getClassFile(IJavaElement jElement) {
        if (jElement instanceof IMember) {
            return ((IMember)jElement).getClassFile();
        }
        return null;
    }

    private boolean isBinary(IJavaElement jElement) {
        if (jElement instanceof IMember) {
            return ((IMember)jElement).isBinary();
        }
        return false;
    }
}

