/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.ui.dialogs.ListDialog;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReorgQueries
implements IReorgQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public ReorgQueries(Wizard wizard) {
        Assert.isNotNull(wizard);
        this.fWizard = wizard;
        this.fShell = null;
    }

    public ReorgQueries(Shell shell) {
        Assert.isNotNull(shell);
        this.fWizard = null;
        this.fShell = shell;
    }

    private Shell getShell() {
        Assert.isTrue(this.fShell == null || this.fWizard == null);
        Assert.isTrue(this.fShell != null || this.fWizard != null);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        return this.fShell;
    }

    public IConfirmQuery createYesYesToAllNoNoToAllQuery(String dialogTitle, boolean allowCancel, int queryID) {
        return new YesYesToAllNoNoToAllQuery(this.getShell(), allowCancel, dialogTitle);
    }

    public IConfirmQuery createYesNoQuery(String dialogTitle, boolean allowCancel, int queryID) {
        return new YesNoQuery(this.getShell(), allowCancel, dialogTitle);
    }

    private static class YesYesToAllNoNoToAllQuery
    implements IConfirmQuery {
        private final boolean fAllowCancel;
        private boolean fYesToAll = false;
        private boolean fNoToAll = false;
        private final Shell fShell;
        private final String fDialogTitle;

        YesYesToAllNoNoToAllQuery(Shell parent, boolean allowCancel, String dialogTitle) {
            this.fShell = parent;
            this.fDialogTitle = dialogTitle;
            this.fAllowCancel = allowCancel;
        }

        public boolean confirm(String question) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, result));
            return this.getResult(result);
        }

        public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, elements, result));
            return this.getResult(result);
        }

        private Runnable createQueryRunnable(String question, int[] result) {
            return new Runnable(this, question, result){
                final /* synthetic */ YesYesToAllNoNoToAllQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesYesToAllNoNoToAllQuery;
                    this.val$question = string;
                    this.val$result = nArray;
                }

                public void run() {
                    int[] resultId = this.getResultIDs();
                    MessageDialog dialog = new MessageDialog(YesYesToAllNoNoToAllQuery.access$0(this.this$1), YesYesToAllNoNoToAllQuery.access$1(this.this$1), null, this.val$question, 3, this.getButtonLabels(), 0);
                    dialog.open();
                    this.val$result[0] = dialog.getReturnCode() == -1 ? (YesYesToAllNoNoToAllQuery.access$2(this.this$1) ? 1 : 3) : resultId[dialog.getReturnCode()];
                }

                private String[] getButtonLabels() {
                    if (YesYesToAllNoNoToAllQuery.access$2(this.this$1)) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
                }

                private int[] getResultIDs() {
                    if (YesYesToAllNoNoToAllQuery.access$2(this.this$1)) {
                        return new int[]{2, 4, 3, 21, 1};
                    }
                    return new int[]{2, 4, 3, 21};
                }
            };
        }

        private Runnable createQueryRunnable(String question, Object[] elements, int[] result) {
            return new Runnable(this, question, elements, result){
                final /* synthetic */ YesYesToAllNoNoToAllQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ Object[] val$elements;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesYesToAllNoNoToAllQuery;
                    this.val$question = string;
                    this.val$elements = objectArray;
                    this.val$result = nArray;
                }

                public void run() {
                    YesNoListDialog dialog = new YesNoListDialog(YesYesToAllNoNoToAllQuery.access$0(this.this$1), true);
                    dialog.setAddCancelButton(false);
                    dialog.setBlockOnOpen(true);
                    dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dialog.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
                    dialog.setTitle(YesYesToAllNoNoToAllQuery.access$1(this.this$1));
                    dialog.setMessage(this.val$question);
                    dialog.setInput(this.val$elements);
                    dialog.open();
                    this.val$result[0] = dialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] result) throws OperationCanceledException {
            switch (result[0]) {
                case 4: {
                    this.fYesToAll = true;
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
                case 21: {
                    this.fNoToAll = true;
                    return false;
                }
            }
            Assert.isTrue(false);
            return false;
        }

        static /* synthetic */ Shell access$0(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fShell;
        }

        static /* synthetic */ String access$1(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fDialogTitle;
        }

        static /* synthetic */ boolean access$2(YesYesToAllNoNoToAllQuery yesYesToAllNoNoToAllQuery) {
            return yesYesToAllNoNoToAllQuery.fAllowCancel;
        }
    }

    private static class YesNoQuery
    implements IConfirmQuery {
        private final Shell fShell;
        private final String fDialogTitle;
        private final boolean fAllowCancel;

        YesNoQuery(Shell parent, boolean allowCancel, String dialogTitle) {
            this.fShell = parent;
            this.fDialogTitle = dialogTitle;
            this.fAllowCancel = allowCancel;
        }

        public boolean confirm(String question) throws OperationCanceledException {
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, result));
            return this.getResult(result);
        }

        public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, elements, result));
            return this.getResult(result);
        }

        private Runnable createQueryRunnable(String question, int[] result) {
            return new Runnable(this, question, result){
                final /* synthetic */ YesNoQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesNoQuery;
                    this.val$question = string;
                    this.val$result = nArray;
                }

                public void run() {
                    MessageDialog dialog = new MessageDialog(YesNoQuery.access$0(this.this$1), YesNoQuery.access$1(this.this$1), null, this.val$question, 3, this.getButtonLabels(), 0);
                    dialog.open();
                    switch (dialog.getReturnCode()) {
                        case -1: {
                            this.val$result[0] = YesNoQuery.access$2(this.this$1) ? 1 : 3;
                            break;
                        }
                        case 0: {
                            this.val$result[0] = 2;
                            break;
                        }
                        case 1: {
                            this.val$result[0] = 3;
                            break;
                        }
                        case 2: {
                            if (YesNoQuery.access$2(this.this$1)) {
                                this.val$result[0] = 1;
                                break;
                            }
                            Assert.isTrue(false);
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                        }
                    }
                }

                private String[] getButtonLabels() {
                    if (YesNoQuery.access$2(this.this$1)) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                }
            };
        }

        private Runnable createQueryRunnable(String question, Object[] elements, int[] result) {
            return new Runnable(this, question, elements, result){
                final /* synthetic */ YesNoQuery this$1;
                private final /* synthetic */ String val$question;
                private final /* synthetic */ Object[] val$elements;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = yesNoQuery;
                    this.val$question = string;
                    this.val$elements = objectArray;
                    this.val$result = nArray;
                }

                public void run() {
                    YesNoListDialog dialog = new YesNoListDialog(YesNoQuery.access$0(this.this$1), false);
                    dialog.setAddCancelButton(false);
                    dialog.setBlockOnOpen(true);
                    dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dialog.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
                    dialog.setTitle(YesNoQuery.access$1(this.this$1));
                    dialog.setMessage(this.val$question);
                    dialog.setInput(this.val$elements);
                    dialog.open();
                    this.val$result[0] = dialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] result) throws OperationCanceledException {
            switch (result[0]) {
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
            }
            Assert.isTrue(false);
            return false;
        }

        static /* synthetic */ Shell access$0(YesNoQuery yesNoQuery) {
            return yesNoQuery.fShell;
        }

        static /* synthetic */ String access$1(YesNoQuery yesNoQuery) {
            return yesNoQuery.fDialogTitle;
        }

        static /* synthetic */ boolean access$2(YesNoQuery yesNoQuery) {
            return yesNoQuery.fAllowCancel;
        }
    }

    private static final class YesNoListDialog
    extends ListDialog {
        private final boolean fYesToAllNoToAll;

        YesNoListDialog(Shell parent, boolean includeYesToAllNoToAll) {
            super(parent, 67632);
            this.fYesToAllNoToAll = includeYesToAllNoToAll;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            this.setReturnCode(buttonId);
            this.close();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            if (this.fYesToAllNoToAll) {
                this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            }
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            if (this.fYesToAllNoToAll) {
                this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            }
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

