/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReorgMoveWizard
extends RefactoringWizard {
    public ReorgMoveWizard(MoveRefactoring ref) {
        super(ref, ReorgMessages.getString("ReorgMoveWizard.3"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    protected boolean hasPreviewPage() {
        return this.getMoveRefactoring().canUpdateReferences() || this.getMoveRefactoring().canEnableQualifiedNameUpdating();
    }

    private MoveRefactoring getMoveRefactoring() {
        return (MoveRefactoring)this.getRefactoring();
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private MoveRefactoring getMoveRefactoring() {
            return (MoveRefactoring)this.getRefactoring();
        }

        protected Object getInitiallySelectedElement() {
            return this.getMoveRefactoring().getCommonParentForInputElements();
        }

        protected IJavaElement[] getJavaElements() {
            return this.getMoveRefactoring().getJavaElements();
        }

        protected IResource[] getResources() {
            return this.getMoveRefactoring().getResources();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getMoveRefactoring().wasCanceled();
        }

        protected RefactoringStatus verifyDestination(Object selected) throws JavaModelException {
            MoveRefactoring refactoring = this.getMoveRefactoring();
            RefactoringStatus refactoringStatus = selected instanceof IJavaElement ? refactoring.setDestination((IJavaElement)selected) : (selected instanceof IResource ? refactoring.setDestination((IResource)selected) : RefactoringStatus.createFatalErrorStatus(ReorgMessages.getString("ReorgMoveWizard.4")));
            this.updateUIStatus();
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setPreviewReview(false);
            MoveRefactoring refactoring = this.getMoveRefactoring();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                refactoring.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean enabled = refactoring.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(enabled);
                if (enabled) {
                    this.fQualifiedNameComponent.setEnabled(refactoring.getUpdateQualifiedNames());
                    if (refactoring.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setPreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                refactoring.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            MoveRefactoring refactoring = this.getMoveRefactoring();
            if (!refactoring.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.getString("JdtMoveAction.update_references"));
            this.fReferenceCheckbox.setSelection(refactoring.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, refactoring){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ MoveRefactoring val$refactoring;
                {
                    this.this$1 = moveInputPage;
                    this.val$refactoring = moveRefactoring;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$refactoring.setUpdateReferences(((Button)e.widget).getSelection());
                    MoveInputPage.access$0(this.this$1);
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            MoveRefactoring refactoring = this.getMoveRefactoring();
            if (!refactoring.canEnableQualifiedNameUpdating() || !refactoring.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(refactoring.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, refactoring, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.fQualifiedNameComponent.setEnabled(false);
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, refactoring){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ MoveRefactoring val$refactoring;
                {
                    this.this$1 = moveInputPage;
                    this.val$refactoring = moveRefactoring;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    MoveInputPage.access$1(this.this$1).setEnabled(enabled);
                    this.val$refactoring.setUpdateQualifiedNames(enabled);
                    MoveInputPage.access$0(this.this$1);
                }
            });
        }

        public void createControl(Composite parent) {
            Composite result;
            if (!this.getMoveRefactoring().hasDestinationSet()) {
                super.createControl(parent);
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            this.addUpdateReferenceComponent(result);
            this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        private boolean canUpdateReferences() {
            return this.getMoveRefactoring().canUpdateReferences();
        }

        static /* synthetic */ void access$0(MoveInputPage moveInputPage) {
            moveInputPage.updateUIStatus();
        }

        static /* synthetic */ QualifiedNameComponent access$1(MoveInputPage moveInputPage) {
            return moveInputPage.fQualifiedNameComponent;
        }
    }
}

