/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveRefactoring;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class ReorgMoveStarter {
    private final MoveRefactoring fMoveRefactoring;

    private ReorgMoveStarter(MoveRefactoring moveRefactoring) {
        Assert.isNotNull(moveRefactoring);
        this.fMoveRefactoring = moveRefactoring;
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IJavaElement destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        MoveRefactoring moveRefactoring = MoveRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (moveRefactoring == null) {
            return null;
        }
        if (!moveRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(moveRefactoring);
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IResource destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        MoveRefactoring moveRefactoring = MoveRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (moveRefactoring == null) {
            return null;
        }
        if (!moveRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(moveRefactoring);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        try {
            if (this.fMoveRefactoring.hasAllInputSet()) {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                this.fMoveRefactoring.setReorgQueries(new ReorgQueries(parent));
                new RefactoringExecutionHelper(this.fMoveRefactoring, RefactoringPreferences.getStopSeverity(), true, parent, (IRunnableContext)context).perform();
            } else {
                ReorgMoveWizard wizard = new ReorgMoveWizard(this.fMoveRefactoring);
                this.fMoveRefactoring.setReorgQueries(new ReorgQueries(wizard));
                new RefactoringStarter().activate(this.fMoveRefactoring, wizard, parent, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }
}

