/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class ReorgMoveAction
extends SelectionDispatchAction {
    public ReorgMoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.getString("ReorgMoveAction.3"));
        this.setDescription(ReorgMessages.getString("ReorgMoveAction.4"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (elements.size() != resources.length + javaElements.length) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.canEnable(resources, javaElements));
            }
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (element == null) {
            return false;
        }
        return MoveRefactoring.isAvailable(new IResource[0], new IJavaElement[]{element}, JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private boolean canEnable(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return MoveRefactoring.isAvailable(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private MoveProjectAction createWorkbenchAction(IStructuredSelection selection) {
        MoveProjectAction action = new MoveProjectAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    private boolean canDelegateToWorkbenchAction(IStructuredSelection selection) {
        return ReorgUtils.containsOnlyProjects(selection.toList());
    }

    public void run(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (this.canEnable(resources, javaElements)) {
                this.startRefactoring(resources, javaElements);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private void startRefactoring(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        MoveRefactoring refactoring = this.createRefactoring(resources, javaElements);
        RefactoringWizard wizard = this.createWizard(refactoring);
        refactoring.setReorgQueries(new ReorgQueries(wizard));
        new RefactoringStarter().activate(refactoring, wizard, this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
    }

    private RefactoringWizard createWizard(MoveRefactoring refactoring) {
        return new ReorgMoveWizard(refactoring);
    }

    private MoveRefactoring createRefactoring(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return MoveRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
    }
}

