/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class ReorgCopyStarter {
    private final CopyRefactoring fCopyRefactoring;

    private ReorgCopyStarter(CopyRefactoring copyRefactoring) {
        Assert.isNotNull(copyRefactoring);
        this.fCopyRefactoring = copyRefactoring;
    }

    public static ReorgCopyStarter create(IJavaElement[] javaElements, IResource[] resources, IJavaElement destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        CopyRefactoring copyRefactoring = CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (copyRefactoring == null) {
            return null;
        }
        if (!copyRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyRefactoring);
    }

    public static ReorgCopyStarter create(IJavaElement[] javaElements, IResource[] resources, IResource destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        CopyRefactoring copyRefactoring = CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (copyRefactoring == null) {
            return null;
        }
        if (!copyRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyRefactoring);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
        this.fCopyRefactoring.setNewNameQueries(new NewNameQueries(parent));
        this.fCopyRefactoring.setReorgQueries(new ReorgQueries(parent));
        new RefactoringExecutionHelper(this.fCopyRefactoring, RefactoringPreferences.getStopSeverity(), false, parent, (IRunnableContext)context).perform();
    }
}

