/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameInputWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class RenameRefactoringWizard
extends RefactoringWizard {
    private final String fInputPageDescription;
    private final String fPageContextHelpId;
    private final ImageDescriptor fInputPageImageDescriptor;

    public RenameRefactoringWizard(String defaultPageTitle, String inputPageDescription, ImageDescriptor inputPageImageDescriptor, String pageContextHelpId) {
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.fInputPageImageDescriptor = inputPageImageDescriptor;
        this.fPageContextHelpId = pageContextHelpId;
    }

    protected boolean hasPreviewPage() {
        Refactoring refactoring = this.getRefactoring();
        if (refactoring instanceof RenameRefactoring) {
            return (((RenameRefactoring)refactoring).getStyle() & 1) != 0;
        }
        return super.hasPreviewPage();
    }

    protected void addUserInputPages() {
        String initialSetting = this.getRenameRefactoring().getCurrentName();
        RenameInputWizardPage inputPage = this.createInputPage(this.fInputPageDescription, initialSetting);
        inputPage.setImageDescriptor(this.fInputPageImageDescriptor);
        this.addPage((IWizardPage)inputPage);
    }

    private IRenameRefactoring getRenameRefactoring() {
        return (IRenameRefactoring)((Object)this.getRefactoring());
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, this.fPageContextHelpId, true, initialSetting){

            protected RefactoringStatus validateTextField(String text) {
                return RenameRefactoringWizard.this.validateNewName(text);
            }
        };
    }

    protected RefactoringStatus validateNewName(String newName) {
        IRenameRefactoring ref = this.getRenameRefactoring();
        ref.setNewName(newName);
        try {
            return ref.checkNewName(newName);
        }
        catch (CoreException e) {
            String msg = e.getMessage() == null ? "" : e.getMessage();
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getFormattedString("RenameRefactoringWizard.internal_error", msg));
        }
    }
}

