/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenameRefactoringAction
extends SelectionDispatchAction {
    public RenameRefactoringAction(IWorkbenchSite site) {
        super(site);
        this.setText("Rename with Participants...");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1);
    }

    public void run(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        try {
            RenameRefactoring refactoring = new RenameRefactoring(element);
            RenameRefactoringAction.run(refactoring, this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), "Rename Refactoring", "Unexpected Exception occured");
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public static void run(RenameRefactoring refactoring, Shell parent) throws CoreException {
        if (refactoring.isAvailable()) {
            UserInterfaceStarter.run(refactoring, parent);
        } else {
            MessageDialog.openInformation((Shell)parent, (String)"Rename Refactoring", (String)"No refactoring available to process the selected element.");
        }
    }
}

