/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.reorg.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private Button fUpdateReferences;
    private Button fUpdateJavaDoc;
    private Button fUpdateComments;
    private Button fUpdateStrings;
    private Button fUpdateQualifiedNames;
    private QualifiedNameComponent fQualifiedNameComponent;
    private static final String UPDATE_REFERENCES = "updateReferences";
    private static final String UPDATE_JAVADOC = "updateJavaDoc";
    private static final String UPDATE_COMMENTS = "updateComments";
    private static final String UPDATE_STRINGS = "updateStrings";
    private static final String UPDATE_QUALIFIED_NAMES = "updateQualifiedNames";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RenameInputWizardPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, isLastUserPage, initialValue);
        this.fHelpContextID = contextHelpId;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)text, 1);
        this.addOptionalUpdateReferencesCheckbox(composite, layouter);
        this.addOptionalUpdateCommentsAndStringCheckboxes(composite, layouter);
        this.addOptionalUpdateQualifiedNameComponent(composite, layouter, layout.marginWidth);
        Dialog.applyDialogFont((Control)superComposite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)this.fHelpContextID);
    }

    protected boolean saveSettings() {
        if (this.getContainer() instanceof Dialog) {
            return ((Dialog)this.getContainer()).getReturnCode() == 0;
        }
        return true;
    }

    public void dispose() {
        if (this.saveSettings()) {
            this.saveBooleanSetting(UPDATE_REFERENCES, this.fUpdateReferences);
            this.saveBooleanSetting(UPDATE_JAVADOC, this.fUpdateJavaDoc);
            this.saveBooleanSetting(UPDATE_COMMENTS, this.fUpdateComments);
            this.saveBooleanSetting(UPDATE_STRINGS, this.fUpdateStrings);
            this.saveBooleanSetting(UPDATE_QUALIFIED_NAMES, this.fUpdateQualifiedNames);
            if (this.fQualifiedNameComponent != null) {
                this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
            }
        }
        super.dispose();
    }

    private void addOptionalUpdateReferencesCheckbox(Composite result, RowLayouter layouter) {
        IReferenceUpdating ref;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = (IReferenceUpdating)refactoring.getAdapter(clazz)) == null || !ref.canEnableUpdateReferences()) {
            return;
        }
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_references");
        boolean defaultValue = this.getBooleanSetting(UPDATE_REFERENCES, ref.getUpdateReferences());
        this.fUpdateReferences = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        ref.setUpdateReferences(this.fUpdateReferences.getSelection());
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(RenameInputWizardPage.this.fUpdateReferences.getSelection());
            }
        });
    }

    private void addOptionalUpdateCommentsAndStringCheckboxes(Composite result, RowLayouter layouter) {
        ITextUpdating refactoring;
        Refactoring refactoring2 = this.getRefactoring();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((refactoring = (ITextUpdating)refactoring2.getAdapter(clazz)) == null || !refactoring.canEnableTextUpdating()) {
            return;
        }
        this.addUpdateJavaDocCheckbox(result, layouter, refactoring);
        this.addUpdateCommentsCheckbox(result, layouter, refactoring);
        this.addUpdateStringsCheckbox(result, layouter, refactoring);
    }

    private void addUpdateJavaDocCheckbox(Composite result, RowLayouter layouter, final ITextUpdating refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_javadoc_references");
        boolean defaultValue = this.getBooleanSetting(UPDATE_JAVADOC, refactoring.getUpdateJavaDoc());
        this.fUpdateJavaDoc = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateJavaDoc(this.fUpdateJavaDoc.getSelection());
        this.fUpdateJavaDoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateJavaDoc(RenameInputWizardPage.this.fUpdateJavaDoc.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addUpdateCommentsCheckbox(Composite result, RowLayouter layouter, final ITextUpdating refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_comment_references");
        boolean defaultValue = this.getBooleanSetting(UPDATE_COMMENTS, refactoring.getUpdateComments());
        this.fUpdateComments = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateComments(this.fUpdateComments.getSelection());
        this.fUpdateComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateComments(RenameInputWizardPage.this.fUpdateComments.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addUpdateStringsCheckbox(Composite result, RowLayouter layouter, final ITextUpdating refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.ppdate_string_references");
        boolean defaultValue = this.getBooleanSetting(UPDATE_STRINGS, refactoring.getUpdateStrings());
        this.fUpdateStrings = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateStrings(this.fUpdateStrings.getSelection());
        this.fUpdateStrings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateStrings(RenameInputWizardPage.this.fUpdateStrings.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addOptionalUpdateQualifiedNameComponent(Composite parent, RowLayouter layouter, int marginWidth) {
        IQualifiedNameUpdating ref;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = (IQualifiedNameUpdating)refactoring.getAdapter(clazz)) == null || !ref.canEnableQualifiedNameUpdating()) {
            return;
        }
        this.fUpdateQualifiedNames = new Button(parent, 32);
        int indent = marginWidth + this.fUpdateQualifiedNames.computeSize((int)-1, (int)-1).x;
        this.fUpdateQualifiedNames.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
        layouter.perform((Control)this.fUpdateQualifiedNames);
        this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, ref, this.getRefactoringSettings());
        layouter.perform((Control)this.fQualifiedNameComponent);
        GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = indent;
        boolean defaultSelection = this.getBooleanSetting(UPDATE_QUALIFIED_NAMES, ref.getUpdateQualifiedNames());
        this.fUpdateQualifiedNames.setSelection(defaultSelection);
        this.fQualifiedNameComponent.setEnabled(defaultSelection);
        this.fUpdateQualifiedNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                RenameInputWizardPage.this.fQualifiedNameComponent.setEnabled(enabled);
                ref.setUpdateQualifiedNames(enabled);
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    protected String getLabelText() {
        return RefactoringMessages.getString("RenameInputWizardPage.enter_name");
    }

    protected boolean getBooleanSetting(String key, boolean defaultValue) {
        String update = this.getRefactoringSettings().get(key);
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return defaultValue;
    }

    protected void saveBooleanSetting(String key, Button checkBox) {
        if (checkBox != null) {
            this.getRefactoringSettings().put(key, checkBox.getSelection());
        }
    }

    private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        layouter.perform((Control)checkBox);
        return checkBox;
    }

    private void updateForcePreview() {
        boolean forcePreview = false;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextUpdating tu = (ITextUpdating)refactoring.getAdapter(clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IQualifiedNameUpdating qu = (IQualifiedNameUpdating)refactoring.getAdapter(clazz2);
        if (tu != null) {
            boolean bl = forcePreview = tu.getUpdateComments() || tu.getUpdateJavaDoc() || tu.getUpdateStrings();
        }
        if (qu != null) {
            forcePreview |= qu.getUpdateQualifiedNames();
        }
        this.getRefactoringWizard().setPreviewReview(forcePreview);
    }
}

