/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaElementContentProvider {
    private final int fStopExpandingAtType;

    public DestinationContentProvider() {
        this(4, false, false);
    }

    public DestinationContentProvider(int stopExpandingAtType, boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
        this.fStopExpandingAtType = stopExpandingAtType;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            if (javaElement.getElementType() == this.fStopExpandingAtType) {
                return false;
            }
            if (javaElement.getElementType() == 3 && ((IPackageFragmentRoot)javaElement).isArchive()) {
                return false;
            }
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaModel) {
                return StandardJavaElementContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), DestinationContentProvider.getOpenNonJavaProjects((IJavaModel)parentElement));
            }
            return super.getChildren(parentElement);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaModel model) throws JavaModelException {
        Object[] nonJavaProjects = model.getNonJavaResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonJavaProjects.length);
        int i = 0;
        while (i < nonJavaProjects.length) {
            IProject project = (IProject)nonJavaProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

