/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.MessageWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.wizard.IWizardPage;

public class DeleteWizard
extends RefactoringWizard {
    public DeleteWizard() {
        this.setDefaultPageTitle(RefactoringMessages.getString("DeleteWizard.1"));
    }

    public void initialize(Refactoring refactoring) {
        super.initialize(refactoring);
        ((JavaDeleteProcessor)this.getDeleteRefactoring().getProcessor()).setQueries(new ReorgQueries(this));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new DeleteInputPage());
    }

    protected int getMessageLineWidthInChars() {
        return 0;
    }

    public boolean hasPreviewPage() {
        return false;
    }

    protected boolean yesNoStyle() {
        return true;
    }

    public boolean needsProgressMonitor() {
        return (this.getDeleteRefactoring().getStyle() & 4) != 0;
    }

    private DeleteRefactoring getDeleteRefactoring() {
        return (DeleteRefactoring)this.getRefactoring();
    }

    private static class DeleteInputPage
    extends MessageWizardPage {
        private static final String PAGE_NAME = "DeleteInputPage";

        public DeleteInputPage() {
            super(PAGE_NAME, true, 2);
        }

        private JavaDeleteProcessor getDeleteProcessor() {
            return (JavaDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor();
        }

        protected String getMessageString() {
            try {
                if (1 == this.numberOfSelectedElements()) {
                    String pattern = this.createConfirmationStringForOneElement();
                    String name = this.getNameOfSingleSelectedElement();
                    return MessageFormat.format(pattern, name);
                }
                String pattern = this.createConfirmationStringForManyElements();
                return MessageFormat.format(pattern, String.valueOf(this.numberOfSelectedElements()));
            }
            catch (JavaModelException e) {
                if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                    JavaPlugin.log(e);
                }
                this.setPageComplete(false);
                if (e.isDoesNotExist()) {
                    return RefactoringMessages.getString("DeleteWizard.12");
                }
                return RefactoringMessages.getString("DeleteWizard.2");
            }
        }

        private String getNameOfSingleSelectedElement() throws JavaModelException {
            if (this.getSingleSelectedResource() != null) {
                return ReorgUtils.getName(this.getSingleSelectedResource());
            }
            return ReorgUtils.getName(this.getSingleSelectedJavaElement());
        }

        private IJavaElement getSingleSelectedJavaElement() {
            IJavaElement[] elements = this.getSelectedJavaElements();
            return elements.length == 1 ? elements[0] : null;
        }

        private IResource getSingleSelectedResource() {
            IResource[] resources = this.getSelectedResources();
            return resources.length == 1 ? resources[0] : null;
        }

        private int numberOfSelectedElements() {
            return this.getSelectedJavaElements().length + this.getSelectedResources().length;
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getDeleteProcessor().wasCanceled();
        }

        private String createConfirmationStringForOneElement() throws JavaModelException {
            IJavaElement[] elements = this.getSelectedJavaElements();
            if (elements.length == 1) {
                IJavaElement element = elements[0];
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return RefactoringMessages.getString("DeleteWizard.3");
                }
                if (!DeleteInputPage.isLinkedResource(element)) {
                    return RefactoringMessages.getString("DeleteWizard.4");
                }
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(element)) {
                    return RefactoringMessages.getString("DeleteWizard.6");
                }
                return RefactoringMessages.getString("DeleteWizard.5");
            }
            if (DeleteInputPage.isLinked(this.getSelectedResources()[0])) {
                return RefactoringMessages.getString("DeleteWizard.7");
            }
            return RefactoringMessages.getString("DeleteWizard.8");
        }

        private String createConfirmationStringForManyElements() throws JavaModelException {
            IJavaElement[] javaElements;
            IResource[] resources = this.getSelectedResources();
            if (!DeleteInputPage.containsLinkedResources(resources, javaElements = this.getSelectedJavaElements())) {
                return RefactoringMessages.getString("DeleteWizard.9");
            }
            if (!DeleteInputPage.containsLinkedPackagesOrPackageFragmentRoots(javaElements)) {
                return RefactoringMessages.getString("DeleteWizard.10");
            }
            return RefactoringMessages.getString("DeleteWizard.11");
        }

        private static boolean isLinkedPackageOrPackageFragmentRoot(IJavaElement element) {
            if (element instanceof IPackageFragment || element instanceof IPackageFragmentRoot) {
                return DeleteInputPage.isLinkedResource(element);
            }
            return false;
        }

        private static boolean containsLinkedPackagesOrPackageFragmentRoots(IJavaElement[] javaElements) {
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement element = javaElements[i];
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean containsLinkedResources(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement element = javaElements[i];
                if (DeleteInputPage.isLinkedResource(element)) {
                    return true;
                }
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (DeleteInputPage.isLinked(resource)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isDefaultPackageWithLinkedFiles(Object firstElement) throws JavaModelException {
            if (!JavaElementUtil.isDefaultPackage(firstElement)) {
                return false;
            }
            IPackageFragment defaultPackage = (IPackageFragment)firstElement;
            ICompilationUnit[] cus = defaultPackage.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                if (DeleteInputPage.isLinkedResource((IJavaElement)cus[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isLinkedResource(IJavaElement element) {
            return DeleteInputPage.isLinked(ReorgUtils.getResource(element));
        }

        private static boolean isLinked(IResource resource) {
            return resource != null && resource.isLinked();
        }

        private IJavaElement[] getSelectedJavaElements() {
            return this.getDeleteProcessor().getJavaElementsToDelete();
        }

        private IResource[] getSelectedResources() {
            return this.getDeleteProcessor().getResourcesToDelete();
        }
    }
}

