/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;
    static /* synthetic */ Class class$0;

    public CutAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText("Cu&t");
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard, pasteAction);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (!CutAction.containsOnlyElementsInsideCompilationUnits(selection) || CutAction.containsTopLevelTypes(selection)) {
                this.setEnabled(false);
                return;
            }
            this.fCopyToClipboardAction.selectionChanged(selection);
            this.setEnabled(this.fCopyToClipboardAction.isEnabled() && this.isDeleteEnabled(selection));
        }
        catch (CoreException e) {
            if (JavaModelUtil.filterNotPresentException(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean isDeleteEnabled(IStructuredSelection selection) throws CoreException {
        Object[] elements = selection.toArray();
        return DeleteExtensionManager.hasProcessor(elements);
    }

    private static boolean containsOnlyElementsInsideCompilationUnits(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof IJavaElement && ReorgUtils.isInsideCompilationUnit((IJavaElement)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (!CutAction.isTopLevelType(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTopLevelType(Object each) {
        return each instanceof IType && ((IType)each).getDeclaringType() == null;
    }

    public void run(IStructuredSelection selection) {
        try {
            this.selectionChanged(selection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(selection);
                this.runDelete(selection);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private void runDelete(IStructuredSelection selection) throws CoreException, InterruptedException, InvocationTargetException {
        JavaDeleteProcessor processor;
        Object[] elements = selection.toArray();
        DeleteRefactoring refactoring = this.createRefactoring(elements);
        Assert.isTrue((boolean)refactoring.isAvailable());
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((processor = (JavaDeleteProcessor)refactoring.getAdapter(clazz)) != null) {
            processor.setQueries(new ReorgQueries(this.getShell()));
        }
        new RefactoringExecutionHelper(refactoring, RefactoringPreferences.getStopSeverity(), false, this.getShell(), (IRunnableContext)context).perform();
    }

    private DeleteRefactoring createRefactoring(Object[] elements) throws CoreException {
        JavaDeleteProcessor processor;
        DeleteRefactoring ref = new DeleteRefactoring(elements);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((processor = (JavaDeleteProcessor)ref.getAdapter(clazz)) != null) {
            processor.setSuggestGetterSetterDeletion(false);
        }
        return ref;
    }
}

