/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSGroupByKeyComputer;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchOperation;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResultLabelProvider;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.jdt.internal.ui.search.GotoMarkerAction;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;

class NLSSearchResultCollector
implements IJavaSearchResultCollector {
    private static final String MATCH = NLSSearchMessages.getString("SearchResultCollector.match");
    private static final String MATCHES = NLSSearchMessages.getString("SearchResultCollector.matches");
    private static final String DONE = NLSSearchMessages.getString("SearchResultCollector.done");
    private static final String SEARCHING = NLSSearchMessages.getString("SearchResultCollector.searching");
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private IProgressMonitor fMonitor;
    private ISearchResultView fView;
    private NLSSearchOperation fOperation;
    private IFile fPropertyFile;
    private Properties fProperties;
    private HashSet fUsedPropertyNames;
    private int fMatchCount = 0;
    private long fLastUpdateTime;
    private Integer[] fMessageFormatArgs = new Integer[1];

    public NLSSearchResultCollector(IFile propertyFile) {
        this.fPropertyFile = propertyFile;
    }

    public void aboutToStart() {
        this.fView = SearchUI.getSearchResultView();
        this.fMatchCount = 0;
        this.fLastUpdateTime = 0L;
        if (this.fView != null) {
            this.fView.searchStarted(null, this.fOperation.getSingularLabel(), this.fOperation.getPluralLabelPattern(), this.fOperation.getImageDescriptor(), "org.eclipse.jdt.ui.nls.NLSSearchPage", (ILabelProvider)new NLSSearchResultLabelProvider(), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new NLSGroupByKeyComputer(), (IRunnableWithProgress)this.fOperation);
        }
        this.loadProperties(this.fPropertyFile);
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
        if (!this.getProgressMonitor().isCanceled()) {
            this.getProgressMonitor().subTask(SEARCHING);
        }
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        IField field;
        String source;
        if (enclosingElement == null) {
            return;
        }
        if (enclosingElement.getElementType() == 13) {
            return;
        }
        if (enclosingElement.getElementType() == 8 && (source = (field = (IField)enclosingElement).getSource()) != null && fgGetClassNameMatcher.match(source)) {
            return;
        }
        Position keyPosition = new Position(start, Math.max(0, end - start));
        String key = this.findKey(resource, start, end, enclosingElement, keyPosition);
        if (key != null && this.isKeyDefined(key)) {
            return;
        }
        start = keyPosition.getOffset();
        end = start + keyPosition.getLength();
        IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        JavaCore.addJavaElementMarkerAttributes(attributes, (IJavaElement)enclosingElement);
        attributes.put("org.eclipse.jdt.internal.ui.search.handleID", enclosingElement.getHandleIdentifier());
        attributes.put("charStart", new Integer(Math.max(start, 0)));
        attributes.put("charEnd", new Integer(Math.max(end, 0)));
        if (enclosingElement instanceof IMember && ((IMember)enclosingElement).isBinary()) {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.ClassFileEditor");
        } else {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.CompilationUnitEditor");
        }
        marker.setAttributes(attributes);
        this.fView.addMatch(enclosingElement.getElementName(), (Object)enclosingElement, resource, marker);
        ++this.fMatchCount;
        if (!this.getProgressMonitor().isCanceled() && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.fMatchCount));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
    }

    public void done() {
        this.markUnusedPropertyNames();
        if (!this.getProgressMonitor().isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.fMatchCount);
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, matchesString));
        }
        if (this.fView != null) {
            this.fView.searchFinished();
        }
        this.fView = null;
        this.fMonitor = null;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    void setProgressMonitor(IProgressMonitor pm) {
        this.fMonitor = pm;
    }

    void setOperation(NLSSearchOperation operation) {
        this.fOperation = operation;
    }

    protected boolean isKeyDefined(String key) throws CoreException {
        if (key == null) {
            return true;
        }
        if (key != null && this.fProperties.getProperty(key) != null) {
            this.fUsedPropertyNames.add(key);
            return true;
        }
        return false;
    }

    protected String findKey(IResource resource, int start, int end, IJavaElement enclosingElement, Position keyPosition) throws CoreException {
        if (enclosingElement instanceof ISourceReference) {
            int offset = ((ISourceReference)enclosingElement).getSourceRange().getOffset();
            int searchStart = end - offset;
            int matchStart = end;
            String source = ((ISourceReference)enclosingElement).getSource();
            if (searchStart >= source.length()) {
                return null;
            }
            if ((source = source.substring(searchStart)).charAt(0) != '.' || Character.isWhitespace(source.charAt(0))) {
                return null;
            }
            int firstBraket = source.indexOf(40);
            int searchEnd = source.indexOf(41);
            if (searchEnd == -1 || firstBraket == -1 || searchEnd <= firstBraket) {
                return null;
            }
            int firstQuote = source.indexOf(34);
            matchStart += firstQuote + 1;
            int secondQuote = source.indexOf(34, firstQuote + 1);
            if (secondQuote == -1 || secondQuote <= firstQuote) {
                return null;
            }
            keyPosition.setOffset(matchStart);
            keyPosition.setLength(Math.max(1, secondQuote - firstQuote - 1));
            return source.substring(firstQuote + 1, secondQuote);
        }
        return null;
    }

    protected void markUnusedPropertyNames() {
        Object key = new Object();
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (this.fUsedPropertyNames.contains(propertyName)) continue;
            IMarker marker = null;
            try {
                marker = this.fPropertyFile.createMarker("org.eclipse.search.searchmarker");
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
                continue;
            }
            int start = this.findPropertyNameStartPosition(propertyName);
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("message", NLSSearchMessages.getFormattedString("NLSSearchResultCollector.unusedKeys", this.fPropertyFile.getName()));
            attributes.put("charStart", new Integer(Math.max(start, 0)));
            attributes.put("charEnd", new Integer(Math.max(start + propertyName.length(), 0)));
            try {
                marker.setAttributes(attributes);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
                continue;
            }
            this.fView.addMatch(this.fPropertyFile.getName(), key, (IResource)this.fPropertyFile, marker);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int findPropertyNameStartPosition(String propertyName) {
        stream = null;
        lineReader = null;
        try {
            stream = this.fPropertyFile.getContents();
            lineReader = new LineReader(stream);
        }
        catch (CoreException cex) {
            JavaPlugin.log(cex);
            return -1;
        }
        catch (IOException v0) {
            if (stream == null) return -1;
            try {
                stream.close();
                return -1;
            }
            catch (IOException ce) {
                JavaPlugin.log(ce);
            }
            return -1;
        }
        start = 0;
        try {
            try {
                buf = new StringBuffer(80);
                eols = lineReader.readLine(buf);
                keyLength = propertyName.length();
                while (eols > 0) {
                    line = buf.toString();
                    i = line.indexOf(propertyName);
                    charPos = i + keyLength;
                    terminatorChar = '\u0000';
                    v1 = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -1;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
                var13_16 = null;
                try {
                    lineReader.close();
                    return -1;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                return -1;
            }
        }
        catch (Throwable var14_22) {
            var13_17 = null;
            ** try [egrp 4[TRYBLOCK] [6 : 255->262)] { 
lbl55:
            // 1 sources

            lineReader.close();
            throw var14_22;
lbl57:
            // 1 sources

            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            throw var14_22;
        }
        {
            var13_18 = null;
        }
        try {}
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return start;
        }
        lineReader.close();
        return start;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadProperties(IFile propertyFile) {
        BufferedInputStream stream;
        HashSet duplicateKeys = new HashSet();
        this.fProperties = new Properties(duplicateKeys);
        try {
            stream = new BufferedInputStream(propertyFile.getContents());
        }
        catch (CoreException coreException) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(stream);
            }
            catch (IOException iOException) {
                this.fProperties = new Properties();
                Object var4_4 = null;
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException2) {}
                this.reportDuplicateKeys(duplicateKeys.iterator());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {}
            catch (IOException iOException) {}
            ((InputStream)stream).close();
            this.reportDuplicateKeys(duplicateKeys.iterator());
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        this.reportDuplicateKeys(duplicateKeys.iterator());
    }

    protected void reportDuplicateKeys(Iterator duplicateKeys) {
        Object key = new Object();
        while (duplicateKeys.hasNext()) {
            IMarker marker = null;
            try {
                marker = this.fPropertyFile.createMarker("org.eclipse.search.searchmarker");
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
                continue;
            }
            String propertyName = (String)duplicateKeys.next();
            int start = this.findPropertyNameStartPosition(propertyName);
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("message", NLSSearchMessages.getFormattedString("NLSSearchResultCollector.duplicateKeys", this.fPropertyFile.getName()));
            attributes.put("charStart", new Integer(Math.max(start, 0)));
            attributes.put("charEnd", new Integer(Math.max(start + propertyName.length(), 0)));
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.CompilationUnitEditor");
            try {
                marker.setAttributes(attributes);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
                continue;
            }
            this.fView.addMatch(this.fPropertyFile.getName(), key, (IResource)this.fPropertyFile, marker);
        }
    }

    private String getFormattedMatchesString(int count) {
        if (this.fMatchCount == 1) {
            return MATCH;
        }
        this.fMessageFormatArgs[0] = new Integer(count);
        return MessageFormat.format(MATCHES, this.fMessageFormatArgs);
    }
}

