/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizardPage2;
import org.eclipse.jdt.internal.ui.refactoring.nls.MultiStateCellEditor;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSSubstitutionContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

class ExternalizeWizardPage
extends UserInputWizardPage {
    private static final String[] PROPERTIES = new String[3];
    private static final String[] fgTitles;
    private static final int TASK_PROP = 0;
    private static final int KEY_PROP = 1;
    private static final int VAL_PROP = 2;
    private static final int SIZE = 3;
    private static final int ROW_COUNT = 5;
    public static final String DEFAULT_KEY_PREFIX = "";
    public static final String PAGE_NAME = "NLSWizardPage1";
    private Text fPrefixField;
    private Table fTable;
    private TableViewer fViewer;
    private SourceViewer fSourceViewer;
    private Label fTranslateLabel;
    private Label fNoTranslateLabel;
    private Label fSkipLabel;
    private CLabel fPreviewLabel;
    private Button fEditButton;

    static {
        ExternalizeWizardPage.PROPERTIES[0] = "task";
        ExternalizeWizardPage.PROPERTIES[1] = "key";
        ExternalizeWizardPage.PROPERTIES[2] = "value";
        fgTitles = new String[3];
        ExternalizeWizardPage.fgTitles[0] = DEFAULT_KEY_PREFIX;
        ExternalizeWizardPage.fgTitles[1] = NLSUIMessages.getString("ExternalizeWizard.key");
        ExternalizeWizardPage.fgTitles[2] = NLSUIMessages.getString("ExternalizeWizard.value");
    }

    private static Image getNLSImage(NLSSubstitution sub) {
        return ExternalizeWizardPage.getNLSImage(sub.task);
    }

    private static Image getNLSImage(int task) {
        switch (task) {
            case 0: {
                return JavaPluginImages.get("org.eclipse.jdt.ui.translate.gif");
            }
            case 1: {
                return JavaPluginImages.get("org.eclipse.jdt.ui.never_translate.gif");
            }
            case 2: {
                return JavaPluginImages.get("org.eclipse.jdt.ui.skip.gif");
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public ExternalizeWizardPage() {
        super(PAGE_NAME, false);
    }

    private ICompilationUnit getCu() {
        return ((NLSRefactoring)this.getRefactoring()).getCu();
    }

    public void createControl(Composite parent) {
        Composite supercomposite = new Composite(parent, 0);
        supercomposite.setLayout((Layout)new GridLayout());
        this.createKeyPrefixField(supercomposite);
        SashForm composite = new SashForm(supercomposite, 512);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTableViewer((Composite)composite);
        this.createSourceViewer((Composite)composite);
        composite.setWeights(new int[]{55, 45});
        this.createLabels(supercomposite);
        this.setControl((Control)supercomposite);
        Dialog.applyDialogFont((Control)supercomposite);
        WorkbenchHelp.setHelp((Control)supercomposite, (String)"org.eclipse.jdt.ui.externalize_wizard_keyvalue_page_context");
    }

    private void createTableViewer(Composite composite) {
        this.createTableComposite(composite);
        this.fViewer = new TableViewer(this.fTable){

            protected void hookControl(Control control) {
                super.hookControl(control);
                ((Table)control).addMouseListener((MouseListener)new MouseAdapter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        if (this.this$1.getTable().getSelection().length == 0) {
                            return;
                        }
                        TableItem item = this.this$1.getTable().getSelection()[0];
                        if (item.getBounds(0).contains(e.x, e.y)) {
                            List widgetSel = 1.access$0(this.this$1);
                            if (widgetSel == null || widgetSel.size() != 1) {
                                return;
                            }
                            NLSSubstitution s = (NLSSubstitution)widgetSel.get(0);
                            Integer value = (Integer)this.this$1.getCellModifier().getValue((Object)s, ExternalizeWizardPage.access$0()[0]);
                            int newValue = MultiStateCellEditor.getNextValue(3, value);
                            this.this$1.getCellModifier().modify((Object)item, ExternalizeWizardPage.access$0()[0], (Object)new Integer(newValue));
                        }
                    }
                });
            }

            static /* synthetic */ List access$0(1 var0) {
                return var0.getSelectionFromWidget();
            }
        };
        this.fViewer.setUseHashlookup(true);
        CellEditor[] editors = this.createCellEditors();
        this.fViewer.setCellEditors(editors);
        this.fViewer.setColumnProperties(PROPERTIES);
        this.fViewer.setCellModifier((ICellModifier)new CellModifier());
        this.fViewer.setContentProvider((IContentProvider)new NLSSubstitutionContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new NLSSubstitutionLabelProvider());
        this.fViewer.setInput((Object)this.getCu());
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Set selected = ExternalizeWizardPage.this.getSelectedTableEntries();
                if (selected.size() != 1) {
                    return;
                }
                NLSSubstitution nls = (NLSSubstitution)selected.iterator().next();
                if (nls.task == 0) {
                    ExternalizeWizardPage.this.openEditButton(event.getSelection());
                }
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeWizardPage.this.selectionChanged(event);
            }
        });
        this.fViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExternalizeWizardPage.this.fPreviewLabel.setText(ExternalizeWizardPage.DEFAULT_KEY_PREFIX);
            }
        });
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[]{new MultiStateCellEditor((Composite)this.fTable, 3, 0), new TextCellEditor((Composite)this.fTable), new TextCellEditor((Composite)this.fTable)};
        return editors;
    }

    private void createSourceViewer(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(NLSUIMessages.getString("wizardPage.context"));
        l.setLayoutData((Object)new GridData());
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        int styles = 68354;
        this.fSourceViewer = new JavaSourceViewer(c, null, null, false, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools, null));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        try {
            String contents = this.getCu().getBuffer().getContents();
            Document document = new Document(contents);
            tools.setupJavaDocumentPartitioner((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
            this.fSourceViewer.setEditable(false);
            GridData gd = new GridData(1808);
            gd.heightHint = this.convertHeightInCharsToPixels(10);
            this.fSourceViewer.getControl().setLayoutData((Object)gd);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSUIMessages.getString("wizardPage.title"), NLSUIMessages.getString("wizardPage.exception"));
        }
    }

    private void createKeyPrefixField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Label l = new Label(composite, 0);
        l.setText(NLSUIMessages.getString("wizardPage.common_prefix"));
        l.setLayoutData((Object)new GridData());
        this.fPrefixField = new Text(composite, 2052);
        this.fPrefixField.setLayoutData((Object)new GridData(768));
        this.fPrefixField.setText(this.guessPrefix());
        this.fPrefixField.selectAll();
    }

    private String guessPrefix() {
        String cuName = this.getCu().getElementName();
        if (cuName.endsWith(".java")) {
            return String.valueOf(cuName.substring(0, cuName.length() - ".java".length())) + ".";
        }
        return DEFAULT_KEY_PREFIX;
    }

    private void createLabels(Composite parent) {
        Composite labelSuperComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        labelSuperComposite.setLayout((Layout)gl);
        labelSuperComposite.setLayoutData((Object)new GridData(768));
        this.fPreviewLabel = new CLabel(labelSuperComposite, 0);
        this.fPreviewLabel.setLayoutData((Object)new GridData(800));
        this.createNumberLabels(labelSuperComposite);
        this.updateLabels();
    }

    private void createNumberLabels(Composite labelSuperComposite) {
        Composite labelComposite = new Composite(labelSuperComposite, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 6;
        gd.marginWidth = 0;
        labelComposite.setLayout((Layout)gd);
        labelComposite.setLayoutData((Object)new GridData(768));
        Label l1 = new Label(labelComposite, 0);
        l1.setImage(ExternalizeWizardPage.getNLSImage(0));
        l1.setLayoutData((Object)new GridData());
        this.fTranslateLabel = new Label(labelComposite, 0);
        GridData gdata = new GridData(800);
        gdata.widthHint = 60;
        this.fTranslateLabel.setLayoutData((Object)gdata);
        Label l2 = new Label(labelComposite, 0);
        l2.setImage(ExternalizeWizardPage.getNLSImage(1));
        l2.setLayoutData((Object)new GridData());
        this.fNoTranslateLabel = new Label(labelComposite, 0);
        gdata = new GridData(800);
        gdata.widthHint = 60;
        this.fNoTranslateLabel.setLayoutData((Object)gdata);
        Label l3 = new Label(labelComposite, 0);
        l3.setImage(ExternalizeWizardPage.getNLSImage(2));
        l3.setLayoutData((Object)new GridData());
        this.fSkipLabel = new Label(labelComposite, 0);
        gdata = new GridData(800);
        gdata.widthHint = 60;
        this.fSkipLabel.setLayoutData((Object)gdata);
    }

    private void createTableComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        Label l = new Label(comp, 0);
        l.setText(NLSUIMessages.getString("wizardPage.strings_to_externalize"));
        l.setLayoutData((Object)new GridData());
        this.createTable(comp);
    }

    private void createTable(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(1808));
        this.fTable = new Table(c, 101122);
        GridData tableGD = new GridData(1808);
        tableGD.heightHint = SWTUtil.getTableHeightHint(this.fTable, 5);
        tableGD.widthHint = 40;
        this.fTable.setLayoutData((Object)tableGD);
        this.fTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.fTable.setLayout((Layout)layout);
        this.fTable.setHeaderVisible(true);
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnPixelData(20, false), new ColumnWeightData(40, true), new ColumnWeightData(40, true)};
        int i = 0;
        while (i < fgTitles.length) {
            TableColumn tc = new TableColumn(this.fTable, 0, i);
            tc.setText(fgTitles[i]);
            layout.addColumnData(columnLayoutData[i]);
            tc.setResizable(columnLayoutData[i].resizable);
            ++i;
        }
        this.createButtonComposite(c);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComp.setLayout((Layout)gl);
        buttonComp.setLayoutData((Object)new GridData(1040));
        Button translateSelected = new Button(buttonComp, 8);
        translateSelected.setText(NLSUIMessages.getString("wizardPage.Translate_Selected"));
        translateSelected.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(translateSelected);
        translateSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.setSelectedTasks(0);
            }
        });
        Button noTranslateSelected = new Button(buttonComp, 8);
        noTranslateSelected.setText(NLSUIMessages.getString("wizardPage.Never_Translate_Selected"));
        noTranslateSelected.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(noTranslateSelected);
        noTranslateSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.setSelectedTasks(1);
            }
        });
        Button skipSelected = new Button(buttonComp, 8);
        skipSelected.setText(NLSUIMessages.getString("wizardPage.Skip_Selected"));
        skipSelected.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(skipSelected);
        skipSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.setSelectedTasks(2);
            }
        });
        this.fEditButton = new Button(buttonComp, 8);
        this.fEditButton.setText(NLSUIMessages.getString("ExternalizeWizardPage.Edit_key_and_value"));
        this.fEditButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.openEditButton(ExternalizeWizardPage.this.fViewer.getSelection());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openEditButton(ISelection selection) {
        block5: {
            block4: {
                try {
                    Set selected = this.getSelectedTableEntries();
                    Assert.isTrue(selected.size() == 1);
                    NLSSubstitution nls = (NLSSubstitution)selected.iterator().next();
                    NLSInputDialog dialog = new NLSInputDialog(this.getShell(), NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Title"), NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Label"), nls);
                    if (dialog.open() == 1) {
                        Object var6_5 = null;
                        break block4;
                    }
                    KeyValuePair kvPair = dialog.getResult();
                    nls.key = kvPair.getKey();
                    nls.value.setValue(kvPair.getValue());
                    this.fViewer.update((Object)nls, new String[]{PROPERTIES[1], PROPERTIES[2]});
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.fViewer.refresh();
                    this.fViewer.getControl().setFocus();
                    this.fViewer.setSelection(selection);
                    throw throwable;
                }
            }
            this.fViewer.refresh();
            this.fViewer.getControl().setFocus();
            this.fViewer.setSelection(selection);
            return;
        }
        Object var6_7 = null;
        this.fViewer.refresh();
        this.fViewer.getControl().setFocus();
        this.fViewer.setSelection(selection);
    }

    private Set getSelectedTableEntries() {
        ISelection sel = this.fViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            return new HashSet(((IStructuredSelection)sel).toList());
        }
        return new HashSet(0);
    }

    private void setSelectedTasks(int task) {
        Assert.isTrue(task == 0 || task == 1 || task == 2);
        Set selected = this.getSelectedTableEntries();
        String[] props = new String[]{PROPERTIES[0]};
        Iterator iter = selected.iterator();
        while (iter.hasNext()) {
            ((NLSSubstitution)iter.next()).task = task;
        }
        this.fViewer.update(selected.toArray(), props);
        this.updateLabels();
        this.fViewer.getControl().setFocus();
        if (selected.size() == 1) {
            this.fEditButton.setEnabled(task == 0);
        }
    }

    private void updateLabels() {
        NLSSubstitution[] elems = this.getNlsSubstutions();
        this.fTranslateLabel.setText(String.valueOf(NLSUIMessages.getString("wizardPage.translate")) + NLSSubstitution.countItems(elems, 0));
        this.fNoTranslateLabel.setText(String.valueOf(NLSUIMessages.getString("wizardPage.never_translate")) + NLSSubstitution.countItems(elems, 1));
        this.fSkipLabel.setText(String.valueOf(NLSUIMessages.getString("wizardPage.skip")) + NLSSubstitution.countItems(elems, 2));
    }

    private void selectionChanged(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        this.updateEditButtonState(ss);
        if (ss.size() == 0) {
            this.fPreviewLabel.setText(DEFAULT_KEY_PREFIX);
            return;
        }
        NLSSubstitution first = (NLSSubstitution)ss.getFirstElement();
        TextRegion region = first.value.getPosition();
        this.fSourceViewer.setSelectedRange(region.getOffset(), region.getLength());
        this.fSourceViewer.revealRange(region.getOffset(), region.getLength());
        if (ss.size() == 1) {
            String message = NLSUIMessages.getFormattedString("ExternalizeWizardPage.preview", String.valueOf(this.fPrefixField.getText()) + first.key);
            this.fPreviewLabel.setText(message);
        } else {
            String message = NLSUIMessages.getFormattedString("ExternalizeWizardPage.selected", String.valueOf(ss.size()));
            this.fPreviewLabel.setText(message);
        }
    }

    private void updateEditButtonState(IStructuredSelection selection) {
        if (selection.size() != 1) {
            this.fEditButton.setEnabled(false);
            return;
        }
        NLSSubstitution first = (NLSSubstitution)selection.getFirstElement();
        this.fEditButton.setEnabled(first.task == 0);
    }

    private NLSSubstitutionContentProvider getContentProvider() {
        return (NLSSubstitutionContentProvider)this.fViewer.getContentProvider();
    }

    private void initializeRefactoring() {
        NLSRefactoring ref = (NLSRefactoring)this.getRefactoring();
        ref.setNlsSubstitutions(ExternalizeWizardPage.addKeyPrefix(this.getNlsSubstutions(), this.fPrefixField.getText()));
        ref.setLines(this.getContentProvider().getLines());
    }

    public boolean performFinish() {
        this.initializeRefactoring();
        ((ExternalizeWizardPage2)this.getWizard().getPage("NLSWizardPage2")).updateRefactoring();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        return super.getNextPage();
    }

    public void dispose() {
        this.fNoTranslateLabel = null;
        this.fPrefixField = null;
        this.fSkipLabel = null;
        this.fSourceViewer = null;
        this.fTable = null;
        this.fTranslateLabel = null;
        this.fViewer = null;
        this.fEditButton = null;
        super.dispose();
    }

    private static NLSSubstitution[] addKeyPrefix(NLSSubstitution[] subs, String prefix) {
        NLSSubstitution[] result = new NLSSubstitution[subs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new NLSSubstitution(subs[i]);
            result[i].key = String.valueOf(prefix) + subs[i].key;
            ++i;
        }
        return result;
    }

    private NLSSubstitution[] getNlsSubstutions() {
        Object[] input = this.getContentProvider().getElements(this.getCu());
        if (input == null) {
            return new NLSSubstitution[0];
        }
        NLSSubstitution[] result = new NLSSubstitution[input.length];
        int i = 0;
        while (i < input.length) {
            result[i] = (NLSSubstitution)input[i];
            ++i;
        }
        return result;
    }

    private class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property == null) {
                return false;
            }
            if (!(element instanceof NLSSubstitution)) {
                return false;
            }
            if (PROPERTIES[0].equals(property)) {
                return true;
            }
            return ((NLSSubstitution)element).task == 0;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof NLSSubstitution) {
                NLSSubstitution s = (NLSSubstitution)element;
                if (PROPERTIES[1].equals(property)) {
                    return s.key;
                }
                if (PROPERTIES[2].equals(property)) {
                    return s.value.getValue().toString();
                }
                if (PROPERTIES[0].equals(property)) {
                    return new Integer(s.task);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object data;
            if (element instanceof TableItem && (data = ((TableItem)element).getData()) instanceof NLSSubstitution) {
                NLSSubstitution s = (NLSSubstitution)data;
                if (PROPERTIES[1].equals(property)) {
                    s.key = (String)value;
                    ExternalizeWizardPage.this.fViewer.update((Object)s, new String[]{property});
                }
                if (PROPERTIES[2].equals(property)) {
                    s.value.setValue((String)value);
                    ExternalizeWizardPage.this.fViewer.update((Object)s, new String[]{property});
                }
                if (PROPERTIES[0].equals(property)) {
                    s.task = (Integer)value;
                    ExternalizeWizardPage.this.updateLabels();
                    ExternalizeWizardPage.this.fViewer.update((Object)s, new String[]{property});
                }
            }
        }
    }

    private class NLSSubstitutionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        NLSSubstitutionLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof NLSSubstitution) {
                NLSSubstitution s = (NLSSubstitution)element;
                if (columnIndex == 1) {
                    if (s.task == 0) {
                        return s.key;
                    }
                    return ExternalizeWizardPage.DEFAULT_KEY_PREFIX;
                }
                if (columnIndex == 2) {
                    return s.value.getValue();
                }
            }
            return ExternalizeWizardPage.DEFAULT_KEY_PREFIX;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            if (element instanceof NLSSubstitution) {
                return ExternalizeWizardPage.getNLSImage((NLSSubstitution)element);
            }
            return null;
        }
    }

    private class KeyValuePair {
        private String fKey;
        private String fValue;

        public KeyValuePair(String key, String value) {
            this.setKey(key);
            this.setValue(value);
        }

        private void setKey(String key) {
            this.fKey = key;
        }

        private String getKey() {
            return this.fKey;
        }

        private void setValue(String value) {
            this.fValue = value;
        }

        private String getValue() {
            return this.fValue;
        }
    }

    private class NLSInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fKeyField;
        private StringDialogField fValueField;
        private DialogField fMessageField;

        public NLSInputDialog(Shell parent, String title, String message, NLSSubstitution entry) {
            super(parent);
            this.setTitle(title);
            this.fMessageField = new DialogField();
            this.fMessageField.setLabelText(message);
            this.fKeyField = new StringDialogField();
            this.fKeyField.setLabelText(NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Enter_key"));
            this.fKeyField.setDialogFieldListener(this);
            this.fValueField = new StringDialogField();
            this.fValueField.setLabelText(NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Enter_value"));
            this.fValueField.setDialogFieldListener(this);
            this.fKeyField.setText(entry.key);
            this.fValueField.setText(entry.value.getValue());
        }

        public KeyValuePair getResult() {
            KeyValuePair res = new KeyValuePair(this.fKeyField.getText(), this.fValueField.getText());
            return res;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fMessageField.doFillIntoGrid(inner, 2);
            this.fKeyField.doFillIntoGrid(inner, 2);
            this.fValueField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fKeyField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.fKeyField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            LayoutUtil.setWidthHint((Control)this.fValueField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            this.fKeyField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            IStatus keyStatus = this.validateIdentifiers(this.getTokens(this.fKeyField.getText(), ","), true);
            IStatus valueStatus = this.validateIdentifiers(this.getTokens(this.fValueField.getText(), ","), false);
            this.updateStatus(StatusUtil.getMoreSevere(valueStatus, keyStatus));
        }

        protected String[] getTokens(String text, String separator) {
            StringTokenizer tok = new StringTokenizer(text, separator);
            int nTokens = tok.countTokens();
            String[] res = new String[nTokens];
            int i = 0;
            while (i < res.length) {
                res[i] = tok.nextToken().trim();
                ++i;
            }
            return res;
        }

        private IStatus validateIdentifiers(String[] values, boolean isKey) {
            int i = 0;
            while (i < values.length) {
                String val = values[i];
                if (val.length() == 0) {
                    if (isKey) {
                        return new StatusInfo(4, NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Error_empty_key"));
                    }
                    return new StatusInfo(4, NLSUIMessages.getString("ExternalizeWizard.NLSInputDialog.Error_empty_value"));
                }
                if (isKey && !this.validateKey(val)) {
                    return new StatusInfo(4, NLSUIMessages.getFormattedString("ExternalizeWizard.NLSInputDialog.Error_invalid_key", val));
                }
                ++i;
            }
            return new StatusInfo();
        }

        private boolean validateKey(String s) {
            int i = 0;
            while (i < s.length()) {
                if (Character.isWhitespace(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

