/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.UndoManagerAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;

public class UndoRefactoringAction
extends UndoManagerAction {
    private int fPatternLength;

    protected String getName() {
        return RefactoringMessages.getString("UndoRefactoringAction.name");
    }

    protected IRunnableWithProgress createOperation(final ChangeContext context) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    UndoRefactoringAction.this.setPreflightStatus(Refactoring.getUndoManager().performUndo(context, pm));
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ChangeAbortException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected UndoManagerAdapter createUndoManagerListener() {
        return new UndoManagerAdapter(){

            public void undoStackChanged(IUndoManager manager) {
                IAction action = UndoRefactoringAction.this.getAction();
                if (action == null) {
                    return;
                }
                boolean enabled = false;
                String text = null;
                if (manager.anythingToUndo()) {
                    enabled = true;
                    text = UndoRefactoringAction.this.getActionText();
                } else {
                    text = RefactoringMessages.getString("UndoRefactoringAction.label");
                }
                action.setEnabled(enabled);
                action.setText(text);
            }
        };
    }

    public void selectionChanged(IAction action, ISelection s) {
        if (!this.isHooked()) {
            this.hookListener(action);
            this.fPatternLength = RefactoringMessages.getString("UndoRefactoringAction.extendedLabel").length();
            IUndoManager undoManager = Refactoring.getUndoManager();
            if (undoManager.anythingToUndo()) {
                if (undoManager.peekUndoName() != null) {
                    action.setText(this.getActionText());
                }
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
    }

    private String getActionText() {
        return this.shortenText(RefactoringMessages.getFormattedString("UndoRefactoringAction.extendedLabel", Refactoring.getUndoManager().peekUndoName()), this.fPatternLength);
    }
}

