/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardDialog2;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringErrorDialogUtil;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStarter {
    private RefactoringSaveHelper fSaveHelper = new RefactoringSaveHelper();

    public Object activate(Refactoring refactoring, RefactoringWizard wizard, Shell parent, String dialogTitle, boolean mustSaveEditors) throws JavaModelException {
        if (!this.canActivate(mustSaveEditors, parent)) {
            return null;
        }
        RefactoringStatus activationStatus = this.checkActivation(refactoring);
        if (activationStatus.hasFatalError()) {
            return RefactoringErrorDialogUtil.open(dialogTitle, activationStatus, parent);
        }
        wizard.setActivationStatus(activationStatus);
        Object dialog = wizard.hasMultiPageUserInput() ? new RefactoringWizardDialog(parent, wizard) : new RefactoringWizardDialog2(parent, wizard);
        if (dialog.open() == 1) {
            this.fSaveHelper.triggerBuild();
        }
        return null;
    }

    private RefactoringStatus checkActivation(Refactoring refactoring) {
        try {
            CheckConditionsOperation cco = new CheckConditionsOperation(refactoring, 2);
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            context.run(false, false, cco);
            return cco.getStatus();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, "Error", RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    private boolean canActivate(boolean mustSaveEditors, Shell shell) {
        return !mustSaveEditors || this.fSaveHelper.saveEditors(shell);
    }
}

