/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.MoveMembersWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveStaticMembersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public MoveStaticMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RefactoringGroup.move_label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public MoveStaticMembersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(MoveStaticMembersAction.canEnable(MoveStaticMembersAction.getSelectedMembers(selection)));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return MoveStaticMembersRefactoring.isAvailable(new IMember[]{(IMember)element});
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember[] members = MoveStaticMembersAction.getSelectedMembers(selection);
            if (MoveStaticMembersAction.canEnable(members)) {
                this.startRefactoring(members);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IMember member = this.getSelectedMember();
            IMember[] array = new IMember[]{member};
            if (member != null && MoveStaticMembersAction.canEnable(array)) {
                this.startRefactoring(array);
            } else {
                String unavailable = RefactoringMessages.getString("MoveMembersAction.unavailable");
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return null;
        }
        return MoveStaticMembersAction.convertToMemberArray(selection.toArray());
    }

    private static IMember[] convertToMemberArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(obj));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private static boolean canEnable(IMember[] members) throws JavaModelException {
        return MoveStaticMembersRefactoring.isAvailable(members);
    }

    private IMember getSelectedMember() throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }

    private static MoveStaticMembersRefactoring createNewRefactoringInstance(Object[] elements) throws JavaModelException {
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(elements));
        IMember[] methods = memberSet.toArray(new IMember[memberSet.size()]);
        return MoveStaticMembersRefactoring.create(methods, JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private static RefactoringWizard createWizard(MoveStaticMembersRefactoring refactoring) {
        return new MoveMembersWizard(refactoring);
    }

    private void startRefactoring(IMember[] members) throws JavaModelException {
        MoveStaticMembersRefactoring refactoring = MoveStaticMembersAction.createNewRefactoringInstance(members);
        Assert.isNotNull(refactoring);
        if (!ActionUtil.isProcessable(this.getShell(), refactoring.getMembersToMove()[0])) {
            return;
        }
        Object newElementToProcess = new RefactoringStarter().activate(refactoring, MoveStaticMembersAction.createWizard(refactoring), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
        if (newElementToProcess == null) {
            return;
        }
        StructuredSelection mockSelection = new StructuredSelection(newElementToProcess);
        this.selectionChanged((IStructuredSelection)mockSelection);
        if (this.isEnabled()) {
            this.run((IStructuredSelection)mockSelection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("MoveMembersAction.error.title"), (String)RefactoringMessages.getString("MoveMembersAction.error.message"));
        }
    }
}

