/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.MoveInstanceMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveInstanceMethodAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = RefactoringMessages.getString("MoveInstanceMethodAction.dialog_title");

    public MoveInstanceMethodAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public MoveInstanceMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("MoveInstanceMethodAction.Move_Method"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(MoveInstanceMethodAction.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(MoveInstanceMethodAction.canEnabled(selection));
        }
        catch (CoreException coreException) {
            this.setEnabled(false);
        }
    }

    private static boolean canEnabled(JavaTextSelection selection) throws JavaModelException {
        IJavaElement method = selection.resolveEnclosingElement();
        if (!(method instanceof IMethod)) {
            return false;
        }
        return MoveInstanceMethodRefactoring.isAvailable((IMethod)method);
    }

    private static boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        IMethod method = MoveInstanceMethodAction.getSingleSelectedMethod(selection);
        if (method == null) {
            return false;
        }
        return MoveInstanceMethodRefactoring.isAvailable(method);
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IMethod)) {
            return null;
        }
        return (IMethod)first;
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(MoveInstanceMethodAction.canEnable(selection));
            IMethod method = MoveInstanceMethodAction.getSingleSelectedMethod(selection);
            Assert.isNotNull(method);
            this.run(method);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("MoveInstanceMethodAction.unexpected_exception"));
        }
    }

    public void run(ITextSelection selection) {
        try {
            this.run(selection, this.getCompilationUnitForTextSelection());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("MoveInstanceMethodAction.unexpected_exception"));
        }
    }

    private void run(IMethod method) throws JavaModelException {
        MoveInstanceMethodRefactoring refactoring = MoveInstanceMethodRefactoring.create(method, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)RefactoringMessages.getString("MoveInstanceMethodAction.No_reference_or_declaration"));
            return;
        }
        new RefactoringStarter().activate(refactoring, MoveInstanceMethodAction.createWizard(refactoring), this.getShell(), DIALOG_TITLE, true);
    }

    private void run(ITextSelection selection, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull(cu);
        Assert.isTrue(selection.getOffset() >= 0);
        Assert.isTrue(selection.getLength() >= 0);
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        IMethod method = MoveInstanceMethodAction.getMethod(cu, selection);
        if (method != null) {
            this.run(method);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)RefactoringMessages.getString("MoveInstanceMethodAction.No_reference_or_declaration"));
        }
    }

    private static IMethod getMethod(ICompilationUnit cu, ITextSelection selection) throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset((IJavaElement)cu, selection);
        if (element instanceof IMethod) {
            return (IMethod)element;
        }
        return null;
    }

    private ICompilationUnit getCompilationUnitForTextSelection() {
        Assert.isNotNull(this.fEditor);
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    private static RefactoringWizard createWizard(MoveInstanceMethodRefactoring refactoring) {
        return new MoveInstanceMethodWizard(refactoring);
    }
}

