/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class UserInputWizardPage
extends RefactoringWizardPage {
    private final boolean fIsLastUserPage;

    public UserInputWizardPage(String name, boolean isLastUserPage) {
        super(name);
        this.fIsLastUserPage = isLastUserPage;
    }

    public void setPageComplete(RefactoringStatus status) {
        this.getRefactoringWizard().setStatus(status);
        int severity = status.getSeverity();
        if (severity == 4) {
            this.setPageComplete(false);
            this.setErrorMessage(status.getFirstMessage(severity));
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            if (severity == 0) {
                this.setMessage(null, 0);
            } else {
                this.setMessage(status.getFirstMessage(severity), UserInputWizardPage.getCorrespondingIStatusSeverity(severity));
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getRefactoringWizard().setChange(null);
        }
        super.setVisible(visible);
    }

    public IWizardPage getNextPage() {
        if (this.fIsLastUserPage) {
            return this.getRefactoringWizard().computeUserInputSuccessorPage((IWizardPage)this);
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        if (this.fIsLastUserPage) {
            return this.isPageComplete();
        }
        return super.canFlipToNextPage();
    }

    protected boolean performFinish() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        int threshold = RefactoringPreferences.getCheckPassedSeverity();
        RefactoringStatus activationStatus = wizard.getActivationStatus();
        RefactoringStatus inputStatus = null;
        RefactoringStatus status = new RefactoringStatus();
        Refactoring refactoring = this.getRefactoring();
        boolean result = false;
        if (activationStatus != null && activationStatus.getSeverity() > threshold) {
            inputStatus = wizard.checkInput();
        } else {
            CreateChangeOperation create = new CreateChangeOperation(refactoring, 4);
            create.setCheckPassedSeverity(threshold);
            PerformChangeOperation perform = new PerformChangeOperation(create);
            perform.setCheckPassedSeverity(threshold);
            result = wizard.performFinish(perform);
            wizard.setChange(create.getChange());
            if (!result) {
                return false;
            }
            inputStatus = create.getStatus();
        }
        status.merge(activationStatus);
        status.merge(inputStatus);
        if (status.getSeverity() > threshold) {
            wizard.setStatus(status);
            IWizardPage nextPage = wizard.getPage("ErrorPage");
            wizard.getContainer().showPage(nextPage);
            return false;
        }
        return result;
    }

    private static int getCorrespondingIStatusSeverity(int severity) {
        if (severity == 4) {
            return 4;
        }
        if (severity == 3) {
            return 2;
        }
        if (severity == 2) {
            return 2;
        }
        if (severity == 1) {
            return 1;
        }
        return 0;
    }
}

