/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessorExtension;
import org.eclipse.jface.text.contentassist.IContentAssistSubject;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

class TypeContentAssistProcessor
implements IContentAssistProcessor,
IContentAssistProcessorExtension {
    private static final String CLASS_NAME = "$$__$$";
    private static final String CU_NAME = "$$__$$.java";
    private static final String CU_START = "public class $$__$$ { ";
    private static final String CU_END = " }";
    private IType fDeclaringType;

    public TypeContentAssistProcessor(IType declaringType) {
        this.fDeclaringType = declaringType;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubject contentAssistSubject, int documentOffset) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubject contentAssistSubject, int documentOffset) {
        ICompletionProposal[] iCompletionProposalArray;
        String input = "";
        try {
            input = contentAssistSubject.getDocument().get(0, documentOffset);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        if (input.length() == 0) {
            return null;
        }
        String cuString = CU_START + input + CU_END;
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)this.fDeclaringType);
        IPackageFragment defaultPackage = root.getPackageFragment("");
        ICompilationUnit cu = defaultPackage.getCompilationUnit(CU_NAME);
        try {
            try {
                cu = (ICompilationUnit)cu.getWorkingCopy();
                cu.getBuffer().setContents(cuString);
                int cuOffset = CU_START.length() + input.length();
                TypeCompletionCollector collector = new TypeCompletionCollector(cuOffset - documentOffset, this.fDeclaringType.getJavaProject());
                cu.codeComplete(cuOffset, (ICompletionRequestor)collector);
                ICompletionProposal[] proposals = collector.getResults();
                Arrays.sort(proposals, new JavaCompletionProposalComparator());
                iCompletionProposalArray = proposals;
                Object var11_15 = null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                ICompletionProposal[] iCompletionProposalArray2 = null;
                Object var11_16 = null;
                cu.destroy();
                return iCompletionProposalArray2;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            cu.destroy();
            throw throwable;
        }
        cu.destroy();
        return iCompletionProposalArray;
    }

    private static class TypeCompletionCollector
    extends CompletionRequestorAdapter {
        private final ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
        private List fProposals = new ArrayList();
        private int fOffsetReduction;
        private IJavaProject fJavaProject;

        public TypeCompletionCollector(int offsetReduction, IJavaProject javaProject) {
            this.fOffsetReduction = offsetReduction;
            this.fJavaProject = javaProject;
        }

        public void acceptClass(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
            if (TypeCompletionCollector.isDummyClass(typeName)) {
                return;
            }
            ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, modifiers);
            ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
            this.fProposals.add(this.createTypeCompletion(start, end, new String(completionName), descriptor, new String(typeName), new String(packageName), info, relevance));
        }

        public void acceptInterface(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
            if (TypeCompletionCollector.isDummyClass(typeName)) {
                return;
            }
            ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(true, false, modifiers);
            ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
            this.fProposals.add(this.createTypeCompletion(start, end, new String(completionName), descriptor, new String(typeName), new String(packageName), info, relevance));
        }

        public void acceptType(char[] packageName, char[] typeName, char[] completionName, int start, int end, int relevance) {
            if (TypeCompletionCollector.isDummyClass(typeName)) {
                return;
            }
            ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
            this.fProposals.add(this.createTypeCompletion(start, end, new String(completionName), JavaPluginImages.DESC_OBJS_CLASS, new String(typeName), new String(packageName), info, relevance));
        }

        public void acceptPackage(char[] packageName, char[] completionName, int start, int end, int relevance) {
            this.fProposals.add(this.createCompletion(start, end, new String(completionName), JavaPluginImages.DESC_OBJS_PACKAGE, new String(packageName), relevance));
        }

        private static boolean isDummyClass(char[] typeName) {
            return new String(typeName).equals(TypeContentAssistProcessor.CLASS_NAME);
        }

        public JavaCompletionProposal[] getResults() {
            return this.fProposals.toArray(new JavaCompletionProposal[this.fProposals.size()]);
        }

        protected JavaCompletionProposal createCompletion(int start, int end, String completion, ImageDescriptor descriptor, String name, int relevance) {
            return new JavaCompletionProposal(completion, start - this.fOffsetReduction, end - start, this.getImage(descriptor), name, relevance);
        }

        protected JavaCompletionProposal createTypeCompletion(int start, int end, String completion, ImageDescriptor descriptor, String typeName, String containerName, ProposalInfo proposalInfo, int relevance) {
            String fullName = JavaModelUtil.concatenateName(containerName, typeName);
            StringBuffer buf = new StringBuffer(Signature.getSimpleName((String)fullName));
            String typeQualifier = Signature.getQualifier((String)fullName);
            if (typeQualifier.length() > 0) {
                buf.append(" - ");
                buf.append(typeQualifier);
            }
            String name = buf.toString();
            JavaCompletionProposal proposal = new JavaCompletionProposal(completion, start - this.fOffsetReduction, end - start, this.getImage(descriptor), name, relevance);
            proposal.setProposalInfo(proposalInfo);
            return proposal;
        }

        private Image getImage(ImageDescriptor descriptor) {
            return descriptor == null ? null : this.fRegistry.get(descriptor);
        }
    }
}

