/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringStatusDialog;
import org.eclipse.jdt.internal.ui.refactoring.changes.AbortChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.refactoring.changes.ChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class RefactoringExecutionHelper {
    private final IRefactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final boolean fNeedsSavedEditors;
    private ChangeContext fContext;
    static /* synthetic */ Class class$0;

    public RefactoringExecutionHelper(IRefactoring refactoring, int stopSevertity, boolean needsSavedEditors, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSevertity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fNeedsSavedEditors = needsSavedEditors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform() throws InterruptedException, InvocationTargetException {
        RefactoringSaveHelper saveHelper = new RefactoringSaveHelper();
        if (this.fNeedsSavedEditors && !saveHelper.saveEditors(this.fParent)) {
            throw new InterruptedException();
        }
        this.fContext = new ChangeContext(new ChangeExceptionHandler(this.fParent));
        boolean success = false;
        IUndoManager undoManager = Refactoring.getUndoManager();
        Operation op = new Operation();
        IRewriteTarget[] targets = null;
        try {
            block8: {
                try {
                    targets = RefactoringExecutionHelper.getRewriteTargets();
                    RefactoringExecutionHelper.beginCompoundChange(targets);
                    undoManager.aboutToPerformRefactoring();
                    this.fExecContext.run(false, false, (IRunnableWithProgress)op);
                    if (!op.isExecuted()) break block8;
                    if (!op.isUndoable()) {
                        success = false;
                    } else {
                        undoManager.addUndo(this.fRefactoring.getName(), op.getUndoChange());
                        success = true;
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof ChangeAbortException)) throw e;
                    this.handleChangeAbortException((ChangeAbortException)t);
                }
            }
            Object var8_10 = null;
            this.fContext.clearPerformedChanges();
            undoManager.refactoringPerformed(success);
            saveHelper.triggerBuild();
            if (targets == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fContext.clearPerformedChanges();
            undoManager.refactoringPerformed(success);
            saveHelper.triggerBuild();
            if (targets == null) throw throwable;
            RefactoringExecutionHelper.endCompoundChange(targets);
            throw throwable;
        }
        RefactoringExecutionHelper.endCompoundChange(targets);
    }

    private void handleChangeAbortException(ChangeAbortException exception) {
        if (!this.fContext.getTryToUndo()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run(IProgressMonitor pm) throws CoreException {
                                ChangeContext undoContext = new ChangeContext(new AbortChangeExceptionHandler());
                                IChange[] changes = RefactoringExecutionHelper.access$3(2.access$0(this.this$1)).getPerformedChanges();
                                pm.beginTask(RefactoringMessages.getString("RefactoringWizard.undoing"), changes.length);
                                NullProgressMonitor sub = new NullProgressMonitor();
                                int i = changes.length - 1;
                                while (i >= 0) {
                                    IChange change = changes[i];
                                    pm.subTask(change.getName());
                                    change.getUndoChange().perform(undoContext, (IProgressMonitor)sub);
                                    pm.worked(1);
                                    --i;
                                }
                            }
                        }, (IProgressMonitor)monitor);
                    }
                    catch (ChangeAbortException e) {
                        throw new InvocationTargetException(e.getThrowable());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }

            static /* synthetic */ RefactoringExecutionHelper access$0(2 var0) {
                return var0.RefactoringExecutionHelper.this;
            }
        };
        try {
            this.fExecContext.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            this.handleUnexpectedException(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void handleUnexpectedException(InvocationTargetException e) {
        ExceptionHandler.handle(e, RefactoringMessages.getString("RefactoringWizard.refactoring"), RefactoringMessages.getString("RefactoringWizard.unexpected_exception_1"));
    }

    private static void beginCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].beginCompoundChange();
            ++i;
        }
    }

    private static void endCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].endCompoundChange();
            ++i;
        }
    }

    private static IRewriteTarget[] getRewriteTargets() {
        IEditorPart[] editors = JavaPlugin.getInstanciatedEditors();
        ArrayList<IRewriteTarget> result = new ArrayList<IRewriteTarget>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IRewriteTarget target;
            IEditorPart iEditorPart = editors[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.jface.text.IRewriteTarget;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)iEditorPart.getAdapter((Class)clazz)) != null) {
                result.add(target);
            }
            ++i;
        }
        return result.toArray(new IRewriteTarget[result.size()]);
    }

    private class Operation
    implements IRunnableWithProgress {
        public IChange fChange;

        Operation() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    Object var3_5;
                    RefactoringStatusDialog dialog;
                    pm.beginTask("", 10);
                    pm.subTask("");
                    RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkPreconditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                    if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity && (dialog = new RefactoringStatusDialog(RefactoringExecutionHelper.this.fParent, status, RefactoringExecutionHelper.this.fRefactoring.getName(), false)).open() == 1) {
                        throw new InterruptedException();
                    }
                    this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                    try {
                        this.fChange.aboutToPerform(RefactoringExecutionHelper.this.fContext, (IProgressMonitor)new NullProgressMonitor());
                        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(this){
                            final /* synthetic */ Operation this$1;
                            {
                                this.this$1 = operation;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                this.this$1.fChange.perform(RefactoringExecutionHelper.access$3(Operation.access$0(this.this$1)), monitor);
                            }
                        }, (IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                    }
                    catch (Throwable throwable) {
                        var3_5 = null;
                        this.fChange.performed();
                        throw throwable;
                    }
                    {
                        var3_5 = null;
                        this.fChange.performed();
                    }
                }
                catch (ChangeAbortException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                pm.done();
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            pm.done();
        }

        public boolean isExecuted() {
            return this.fChange != null;
        }

        public boolean isUndoable() {
            return this.fChange.isUndoable();
        }

        public IChange getUndoChange() {
            return this.fChange.getUndoChange();
        }

        static /* synthetic */ RefactoringExecutionHelper access$0(Operation operation) {
            return operation.RefactoringExecutionHelper.this;
        }
    }
}

