/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.jdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.jdt.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.jdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;

class PseudoJavaChangeElement
extends ChangeElement {
    private IJavaElement fJavaElement;
    private List fChildren;

    public PseudoJavaChangeElement(ChangeElement parent, IJavaElement element) {
        super(parent);
        this.fJavaElement = element;
        Assert.isNotNull((Object)this.fJavaElement);
    }

    public IJavaElement getJavaElement() {
        return this.fJavaElement;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewer() throws CoreException {
        DefaultChangeElement element = this.getStandardChangeElement();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewer();
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        DefaultChangeElement element = this.getStandardChangeElement();
        if (element != null) {
            IChange change = element.getChange();
            if (change instanceof TextChange) {
                List edits = this.collectTextEditChanges();
                viewer.setInput(TextChangePreviewViewer.createInput(edits.toArray(new TextChange.EditChange[edits.size()]), this.getTextRange()));
            }
        } else {
            viewer.setInput(null);
        }
    }

    public void setActive(boolean active) {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            ChangeElement element = (ChangeElement)iter.next();
            element.setActive(active);
        }
    }

    public int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((ChangeElement)this.fChildren.get(0)).getActive();
        int i = 1;
        while (i < this.fChildren.size()) {
            ChangeElement element = (ChangeElement)this.fChildren.get(i);
            result = ChangeElement.ACTIVATION_TABLE[element.getActive()][result];
            if (result == 1) break;
            ++i;
        }
        return result;
    }

    public ChangeElement[] getChildren() {
        if (this.fChildren == null) {
            return ChangeElement.EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new ChangeElement[this.fChildren.size()]);
    }

    public void addChild(TextEditChangeElement child) {
        this.doAddChild(child);
    }

    public void addChild(PseudoJavaChangeElement child) {
        this.doAddChild(child);
    }

    private void doAddChild(ChangeElement child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(child);
    }

    private DefaultChangeElement getStandardChangeElement() {
        ChangeElement element = this.getParent();
        while (!(element instanceof DefaultChangeElement) && element != null) {
            element = element.getParent();
        }
        return (DefaultChangeElement)element;
    }

    private List collectTextEditChanges() {
        ArrayList<TextChange.EditChange> result = new ArrayList<TextChange.EditChange>(10);
        ChangeElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeElement child = children[i];
            if (child instanceof TextEditChangeElement) {
                result.add(((TextEditChangeElement)child).getTextEditChange());
            } else if (child instanceof PseudoJavaChangeElement) {
                result.addAll(((PseudoJavaChangeElement)child).collectTextEditChanges());
            }
            ++i;
        }
        return result;
    }

    public IRegion getTextRange() throws CoreException {
        ISourceRange range = ((ISourceReference)this.fJavaElement).getSourceRange();
        return new Region(range.getOffset(), range.getLength());
    }
}

