/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.changes.AbortChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.refactoring.changes.ChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class PerformRefactoringUtil {
    private PerformRefactoringUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean performRefactoring(PerformChangeOperation op, Refactoring refactoring, IRunnableContext execContext, Shell parent) {
        ChangeContext context = new ChangeContext(new ChangeExceptionHandler(parent));
        boolean success = false;
        IUndoManager undoManager = Refactoring.getUndoManager();
        try {
            block9: {
                try {
                    op.setChangeContext(context);
                    undoManager.aboutToPerformRefactoring();
                    execContext.run(false, false, (IRunnableWithProgress)op);
                    if (!op.changeExecuted()) break block9;
                    if (!op.getChange().isUndoable()) {
                        success = false;
                    } else {
                        undoManager.addUndo(refactoring.getName(), op.getChange().getUndoChange());
                        success = true;
                    }
                }
                catch (InvocationTargetException e) {
                    IStatus status;
                    Throwable t = e.getTargetException();
                    if (t instanceof CoreException && (status = ((CoreException)t).getStatus()) != null && status.getCode() == 10004 && status.getPlugin().equals(status.getPlugin())) {
                        success = PerformRefactoringUtil.handleChangeAbortException(execContext, context);
                        Object var10_10 = null;
                        context.clearPerformedChanges();
                        undoManager.refactoringPerformed(success);
                        return true;
                    }
                    PerformRefactoringUtil.handleUnexpectedException(e);
                    Object var10_11 = null;
                    context.clearPerformedChanges();
                    undoManager.refactoringPerformed(success);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    Object var10_12 = null;
                    context.clearPerformedChanges();
                    undoManager.refactoringPerformed(success);
                    return false;
                }
            }
            Object var10_14 = null;
            context.clearPerformedChanges();
            undoManager.refactoringPerformed(success);
            return true;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            context.clearPerformedChanges();
            undoManager.refactoringPerformed(success);
            throw throwable;
        }
    }

    private static boolean handleChangeAbortException(IRunnableContext execContext, final ChangeContext context) {
        if (!context.getTryToUndo()) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(this, context){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ChangeContext val$context;
                            {
                                this.this$1 = var1_1;
                                this.val$context = changeContext;
                            }

                            public void run(IProgressMonitor pm) throws CoreException {
                                ChangeContext undoContext = new ChangeContext(new AbortChangeExceptionHandler());
                                IChange[] changes = this.val$context.getPerformedChanges();
                                pm.beginTask(RefactoringMessages.getString("RefactoringWizard.undoing"), changes.length);
                                NullProgressMonitor sub = new NullProgressMonitor();
                                int i = changes.length - 1;
                                while (i >= 0) {
                                    IChange change = changes[i];
                                    pm.subTask(change.getName());
                                    change.getUndoChange().perform(undoContext, (IProgressMonitor)sub);
                                    pm.worked(1);
                                    --i;
                                }
                            }
                        }, (IProgressMonitor)monitor);
                    }
                    catch (ChangeAbortException e) {
                        throw new InvocationTargetException(e.getThrowable());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            execContext.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            PerformRefactoringUtil.handleUnexpectedException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static void handleUnexpectedException(InvocationTargetException e) {
        ExceptionHandler.handle(e, RefactoringMessages.getString("RefactoringWizard.refactoring"), RefactoringMessages.getString("RefactoringWizard.unexpected_exception_1"));
    }
}

