/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditDialog
extends StatusDialog {
    private ParameterInfo fParameter;
    private boolean fEditType;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;

    public ParameterEditDialog(Shell parentShell, ParameterInfo parameter, boolean canEditType) {
        super(parentShell);
        this.fParameter = parameter;
        this.fEditType = canEditType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(RefactoringMessages.getString("ParameterEditDialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        Label label = new Label(result, 0);
        String newName = this.fParameter.getNewName();
        if (newName.length() == 0) {
            label.setText(RefactoringMessages.getString("ParameterEditDialog.message.new"));
        } else {
            label.setText(RefactoringMessages.getFormattedString("ParameterEditDialog.message", newName));
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.fEditType) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ParameterEditDialog.type"));
            this.fType = new Text(result, 2048);
            gd = new GridData(768);
            this.fType.setLayoutData((Object)gd);
            this.fType.setText(this.fParameter.getNewTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
        }
        label = new Label(result, 0);
        this.fName = new Text(result, 2048);
        this.initializeDialogUnits((Control)this.fName);
        label.setText(RefactoringMessages.getString("ParameterEditDialog.name"));
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(45);
        this.fName.setLayoutData((Object)gd);
        this.fName.setText(newName);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditDialog.this.validate((Text)e.widget);
            }
        });
        if (this.fParameter.isAdded()) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ParameterEditDialog.defaultValue"));
            this.fDefaultValue = new Text(result, 2048);
            gd = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gd);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
        }
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setNewTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        super.okPressed();
    }

    private void validate(Text first) {
        IStatus[] result = new IStatus[3];
        if (first == this.fType) {
            result[0] = this.validateType();
            result[1] = this.validateName();
            result[2] = this.validateDefaltValue();
        } else if (first == this.fName) {
            result[0] = this.validateName();
            result[1] = this.validateType();
            result[2] = this.validateDefaltValue();
        } else {
            result[0] = this.validateDefaltValue();
            result[1] = this.validateName();
            result[2] = this.validateType();
        }
        int i = 0;
        while (i < result.length) {
            IStatus status = result[i];
            if (status != null && !status.isOK()) {
                this.updateStatus(status);
                return;
            }
            ++i;
        }
        this.updateStatus((IStatus)this.createOkStatus());
    }

    private IStatus validateType() {
        if (this.fType == null) {
            return null;
        }
        String typeName = this.fType.getText();
        if (ChangeSignatureRefactoring.isValidParameterTypeName(typeName)) {
            return this.createOkStatus();
        }
        String msg = RefactoringMessages.getFormattedString("ParameterEditDialog.9", new String[]{typeName});
        return this.createErrorStatus(msg);
    }

    private Status createErrorStatus(String message) {
        return new Status(4, JavaPlugin.getPluginId(), 4, message, null);
    }

    private IStatus validateName() {
        if (this.fName == null) {
            return null;
        }
        String text = this.fName.getText();
        if (text.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.getString("ParameterEditDialog.name.error"));
        }
        return JavaConventions.validateFieldName((String)text);
    }

    private IStatus validateDefaltValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String s = this.fDefaultValue.getText();
        if (s.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.getString("ParameterEditDialog.defaultValue.error"));
        }
        return this.createOkStatus();
    }

    private Status createOkStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }
}

