/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.ComboContentAssistSubjectAdapter;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.TypeContentAssistProcessor;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistSubject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveMembersWizard
extends RefactoringWizard {
    public MoveMembersWizard(MoveStaticMembersRefactoring ref) {
        super(ref, RefactoringMessages.getString("MoveMembersWizard.page_title"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveMembersInputPage());
    }

    private static class MoveMembersInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "MoveMembersInputPage";
        private static final int LABEL_FLAGS = 1041;
        private Combo fDestinationField;
        private static final int MRU_COUNT = 10;
        private static List fgMruDestinations = new ArrayList(10);
        private ContentAssistant fContentAssistant;

        public MoveMembersInputPage() {
            super(PAGE_NAME, true);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                String message = RefactoringMessages.getFormattedString("MoveMembersInputPage.descriptionKey", new String[]{new Integer(this.getMoveRefactoring().getMembersToMove().length).toString(), JavaModelUtil.getFullyQualifiedName(this.getMoveRefactoring().getDeclaringType())});
                this.setDescription(message);
            }
            super.setVisible(visible);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            composite.setLayout((Layout)gl);
            this.addLabel(composite);
            this.addDestinationControls(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.move_members_wizard_page_context");
        }

        private void addLabel(Composite parent) {
            Label label = new Label(parent, 0);
            IMember[] members = this.getMoveRefactoring().getMembersToMove();
            if (members.length == 1) {
                label.setText(RefactoringMessages.getFormattedString("MoveMembersInputPage.destination_single", JavaElementLabels.getElementLabel((IJavaElement)members[0], 1041)));
            } else {
                label.setText(RefactoringMessages.getFormattedString("MoveMembersInputPage.destination_multi", String.valueOf(members.length)));
            }
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }

        private void addDestinationControls(Composite composite) {
            this.fDestinationField = new Combo(composite, 2052);
            this.fDestinationField.setFocus();
            this.fDestinationField.setLayoutData((Object)new GridData(768));
            this.fDestinationField.setItems(fgMruDestinations.toArray(new String[fgMruDestinations.size()]));
            this.fDestinationField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.handleDestinationChanged();
                }

                private void handleDestinationChanged() {
                    IStatus status = JavaConventions.validateJavaTypeName((String)MoveMembersInputPage.access$0(this.this$1).getText());
                    if (status.getSeverity() == 4) {
                        this.error(status.getMessage());
                    } else {
                        try {
                            IType resolvedType = MoveMembersInputPage.access$1(this.this$1).getDeclaringType().getJavaProject().findType(MoveMembersInputPage.access$0(this.this$1).getText());
                            IStatus validationStatus = MoveMembersInputPage.access$2(resolvedType, MoveMembersInputPage.access$0(this.this$1).getText());
                            if (validationStatus.isOK()) {
                                this.this$1.setErrorMessage(null);
                                this.this$1.setPageComplete(true);
                            } else {
                                this.error(validationStatus.getMessage());
                            }
                        }
                        catch (JavaModelException ex) {
                            JavaPlugin.log(ex);
                            this.error(RefactoringMessages.getString("MoveMembersInputPage.invalid_name"));
                        }
                    }
                }

                private void error(String message) {
                    this.this$1.setErrorMessage(message);
                    this.this$1.setPageComplete(false);
                }
            });
            if (fgMruDestinations.size() > 0) {
                this.fDestinationField.select(0);
            } else {
                this.setPageComplete(false);
            }
            this.fContentAssistant = this.createContentAssistant(this.fDestinationField);
            Button button = new Button(composite, 8);
            button.setText(RefactoringMessages.getString("MoveMembersInputPage.browse"));
            button.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveMembersInputPage.access$3(this.this$1);
                }
            });
        }

        private ContentAssistant createContentAssistant(Combo combo) {
            ContentAssistant contentAssistant = new ContentAssistant();
            IType declaringType = this.getMoveRefactoring().getDeclaringType();
            TypeContentAssistProcessor processor = new TypeContentAssistProcessor(declaringType);
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            ContentAssistPreference.configure(contentAssistant, JavaPlugin.getDefault().getJavaTextTools().getPreferenceStore());
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(new IInformationControlCreator(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }
            });
            combo.addKeyListener((KeyListener)new KeyAdapter(this, contentAssistant){
                final /* synthetic */ MoveMembersInputPage this$1;
                private final /* synthetic */ ContentAssistant val$contentAssistant;
                {
                    this.this$1 = moveMembersInputPage;
                    this.val$contentAssistant = contentAssistant;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == ' ' && e.stateMask == 262144) {
                        e.doit = false;
                        String errorMessage = this.val$contentAssistant.showPossibleCompletions();
                        if (errorMessage != null) {
                            this.this$1.setErrorMessage(errorMessage);
                        }
                    }
                }
            });
            contentAssistant.install((IContentAssistSubject)new ComboContentAssistSubjectAdapter(combo));
            return contentAssistant;
        }

        public void dispose() {
            if (this.fContentAssistant != null) {
                this.fContentAssistant.uninstall();
                this.fContentAssistant = null;
                super.dispose();
            }
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            try {
                String destination = this.fDestinationField.getText();
                if (!fgMruDestinations.remove(destination) && fgMruDestinations.size() >= 10) {
                    fgMruDestinations.remove(fgMruDestinations.size() - 1);
                }
                fgMruDestinations.add(0, destination);
                this.getMoveRefactoring().setDestinationTypeFullyQualifiedName(destination);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.getString("MoveMembersInputPage.move_Member"), RefactoringMessages.getString("MoveMembersInputPage.exception"));
            }
        }

        private IJavaSearchScope createWorkspaceSourceScope() {
            try {
                return RefactoringScopeFactory.create((IJavaElement)this.getMoveRefactoring().getDeclaringType().getJavaProject());
            }
            catch (JavaModelException e) {
                String title = RefactoringMessages.getString("MoveMembersInputPage.move");
                String message = RefactoringMessages.getString("MoveMembersInputPage.internal_error");
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getMoveRefactoring().getDeclaringType().getJavaProject()}, (boolean)true);
            }
        }

        private void openTypeSelectionDialog() {
            int elementKinds = 0;
            IJavaSearchScope scope = this.createWorkspaceSourceScope();
            TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), elementKinds, scope);
            dialog.setTitle(RefactoringMessages.getString("MoveMembersInputPage.choose_Type"));
            dialog.setMessage(RefactoringMessages.getString("MoveMembersInputPage.dialogMessage"));
            dialog.setUpperListLabel(RefactoringMessages.getString("MoveMembersInputPage.upperListLabel"));
            dialog.setLowerListLabel(RefactoringMessages.getString("MoveMembersInputPage.lowerListLabel"));
            dialog.setValidator(new ISelectionStatusValidator(this, scope){
                final /* synthetic */ MoveMembersInputPage this$1;
                private final /* synthetic */ IJavaSearchScope val$scope;
                {
                    this.this$1 = moveMembersInputPage;
                    this.val$scope = iJavaSearchScope;
                }

                public IStatus validate(Object[] selection) {
                    Assert.isTrue(selection.length <= 1);
                    if (selection.length == 0) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.Invalid_selection"), null);
                    }
                    Object element = selection[0];
                    if (!(element instanceof TypeInfo)) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.Invalid_selection"), null);
                    }
                    try {
                        TypeInfo info = (TypeInfo)element;
                        return MoveMembersInputPage.access$2(info.resolveType(this.val$scope), info.getTypeName());
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.internal_error"), null);
                    }
                }
            });
            dialog.setMatchEmptyString(false);
            dialog.setFilter(this.createInitialFilter());
            if (dialog.open() == 1) {
                return;
            }
            IType firstResult = (IType)dialog.getFirstResult();
            this.fDestinationField.setText(JavaModelUtil.getFullyQualifiedName(firstResult));
        }

        private String createInitialFilter() {
            if (!this.fDestinationField.getText().trim().equals("")) {
                return this.fDestinationField.getText();
            }
            return this.getMoveRefactoring().getDeclaringType().getElementName();
        }

        private static IStatus validateDestinationType(IType type, String typeName) {
            if (type == null || !type.exists()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getFormattedString("MoveMembersInputPage.not_found", typeName), null);
            }
            if (type.isBinary()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.no_binary"), null);
            }
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        private MoveStaticMembersRefactoring getMoveRefactoring() {
            return (MoveStaticMembersRefactoring)this.getRefactoring();
        }

        static /* synthetic */ Combo access$0(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.fDestinationField;
        }

        static /* synthetic */ MoveStaticMembersRefactoring access$1(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.getMoveRefactoring();
        }

        static /* synthetic */ IStatus access$2(IType iType, String string) {
            return MoveMembersInputPage.validateDestinationType(iType, string);
        }

        static /* synthetic */ void access$3(MoveMembersInputPage moveMembersInputPage) {
            moveMembersInputPage.openTypeSelectionDialog();
        }
    }
}

