/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveInstanceMethodWizard
extends RefactoringWizard {
    public MoveInstanceMethodWizard(MoveInstanceMethodRefactoring ref) {
        super(ref, RefactoringMessages.getString("MoveInstanceMethodWizard.Move_Method"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInstanceMethodInputPage());
    }

    private static class MoveInstanceMethodInputPage
    extends UserInputWizardPage {
        private static final String PAGE_NAME = "MOVE_INSTANCE_METHOD_INPUT_PAGE";
        private static final int ROW_COUNT = 7;
        private static final int LABEL_FLAGS = 19;

        public MoveInstanceMethodInputPage() {
            super(PAGE_NAME, true);
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            result.setLayout((Layout)gl);
            this.createNewReceiverList(result);
            this.createNewMethodNameField(result);
            this.createOriginalReceiverParameterNameField(result);
            Dialog.applyDialogFont((Control)result);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.move_members_wizard_page_context");
        }

        private void createOriginalReceiverParameterNameField(Composite result) {
            Label label = new Label(result, 4);
            label.setText(RefactoringMessages.getString("MoveInstanceMethodInputPage.Original_parameter"));
            label.setLayoutData((Object)new GridData());
            Text text = new Text(result, 2052);
            text.setText(this.getMoveRefactoring().getOriginalReceiverParameterName());
            text.setLayoutData((Object)new GridData(768));
            text.addModifyListener(new ModifyListener(this, text){
                final /* synthetic */ MoveInstanceMethodInputPage this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = moveInstanceMethodInputPage;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent arg0) {
                    RefactoringStatus status = MoveInstanceMethodInputPage.access$0(this.this$1).setOriginalReceiverParameterName(this.val$text.getText());
                    this.this$1.setPageComplete(status);
                }
            });
        }

        private void createNewMethodNameField(Composite result) {
            Label label = new Label(result, 4);
            label.setText(RefactoringMessages.getString("MoveInstanceMethodInputPage.New_name"));
            label.setLayoutData((Object)new GridData());
            Text text = new Text(result, 2052);
            text.setText(this.getMoveRefactoring().getNewMethodName());
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            text.setFocus();
            text.addModifyListener(new ModifyListener(this, text){
                final /* synthetic */ MoveInstanceMethodInputPage this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = moveInstanceMethodInputPage;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent arg0) {
                    RefactoringStatus status = MoveInstanceMethodInputPage.access$0(this.this$1).setNewMethodName(this.val$text.getText());
                    this.this$1.setPageComplete(status);
                }
            });
        }

        private void createNewReceiverList(Composite result) {
            Label label = new Label(result, 4);
            IMethod method = this.getMoveRefactoring().getMethodToMove();
            label.setText(RefactoringMessages.getFormattedString("MoveInstanceMethodInputPage.New_receiver", JavaElementLabels.getElementLabel((IJavaElement)method, 19)));
            GridData gd0 = new GridData();
            gd0.horizontalSpan = 2;
            label.setLayoutData((Object)gd0);
            TableLayoutComposite layouter = new TableLayoutComposite(result, 0);
            this.addColumnLayoutData(layouter);
            Table table = new Table((Composite)layouter, 67588);
            table.setHeaderVisible(true);
            table.setLinesVisible(false);
            TableColumn column0 = new TableColumn(table, 0);
            column0.setText(RefactoringMessages.getString("MoveInstanceMethodInputPage.Name"));
            column0.setResizable(true);
            TableColumn column1 = new TableColumn(table, 0);
            column1.setText(RefactoringMessages.getString("MoveInstanceMethodInputPage.Type_Name"));
            column1.setResizable(true);
            TableViewer viewer = new TableViewer(table);
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new NewReceiverLabelProvider(this.getMoveRefactoring()));
            MoveInstanceMethodRefactoring.INewReceiver[] possibleNewReceivers = this.getMoveRefactoring().getPossibleNewReceivers();
            Assert.isTrue(possibleNewReceivers.length > 0);
            viewer.setInput((Object)possibleNewReceivers);
            MoveInstanceMethodRefactoring.INewReceiver chosen = possibleNewReceivers[0];
            viewer.setSelection((ISelection)new StructuredSelection(new Object[]{chosen}));
            this.getMoveRefactoring().chooseNewReceiver(chosen);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ MoveInstanceMethodInputPage this$1;
                {
                    this.this$1 = moveInstanceMethodInputPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    Object first = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (!(first instanceof MoveInstanceMethodRefactoring.INewReceiver)) {
                        return;
                    }
                    MoveInstanceMethodInputPage.access$0(this.this$1).chooseNewReceiver((MoveInstanceMethodRefactoring.INewReceiver)first);
                }
            });
            GridData gd = new GridData(768);
            gd.heightHint = SWTUtil.getTableHeightHint(table, 7);
            gd.horizontalSpan = 2;
            layouter.setLayoutData(gd);
        }

        private void addColumnLayoutData(TableLayoutComposite layouter) {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        }

        private MoveInstanceMethodRefactoring getMoveRefactoring() {
            return (MoveInstanceMethodRefactoring)this.getRefactoring();
        }

        static /* synthetic */ MoveInstanceMethodRefactoring access$0(MoveInstanceMethodInputPage moveInstanceMethodInputPage) {
            return moveInstanceMethodInputPage.getMoveRefactoring();
        }

        private static final class NewReceiverLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private final MoveInstanceMethodRefactoring fRefactoring;
            private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider();

            NewReceiverLabelProvider(MoveInstanceMethodRefactoring refactoring) {
                this.fRefactoring = refactoring;
            }

            public void dispose() {
                super.dispose();
                this.fJavaElementLabelProvider.dispose();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                MoveInstanceMethodRefactoring.INewReceiver newReceiver = (MoveInstanceMethodRefactoring.INewReceiver)element;
                switch (columnIndex) {
                    case 0: {
                        if (newReceiver.isParameter()) {
                            return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
                        }
                        Assert.isTrue(newReceiver.isField());
                        IField field = this.getField(newReceiver);
                        if (field == null) {
                            return null;
                        }
                        return this.fJavaElementLabelProvider.getImage((Object)field);
                    }
                    case 1: {
                        return null;
                    }
                }
                Assert.isTrue(false);
                return null;
            }

            private IField getField(MoveInstanceMethodRefactoring.INewReceiver newReceiver) {
                if (!(newReceiver.getBinding() instanceof IVariableBinding)) {
                    return null;
                }
                try {
                    return Bindings.findField((IVariableBinding)newReceiver.getBinding(), this.fRefactoring.getSourceCU().getJavaProject());
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return null;
                }
            }

            public String getColumnText(Object element, int columnIndex) {
                MoveInstanceMethodRefactoring.INewReceiver newReceiver = (MoveInstanceMethodRefactoring.INewReceiver)element;
                switch (columnIndex) {
                    case 0: {
                        return newReceiver.getName();
                    }
                    case 1: {
                        return Bindings.getFullyQualifiedName(newReceiver.getType());
                    }
                }
                Assert.isTrue(false);
                return null;
            }
        }
    }
}

