/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInnerToTopRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveInnerToTopWizard
extends RefactoringWizard {
    public MoveInnerToTopWizard(Refactoring ref) {
        super(ref, RefactoringMessages.getString("MoveInnerToTopWizard.Move_Inner"));
    }

    protected void addUserInputPages() {
        if (this.getMoveRefactoring().isCreatingInstanceFieldPossible()) {
            this.addPage((IWizardPage)new MoveInnerToToplnputPage(this.getInitialNameForEnclosingInstance()));
        } else {
            this.setChangeCreationCancelable(false);
        }
    }

    private String getInitialNameForEnclosingInstance() {
        return this.getMoveRefactoring().getEnclosingInstanceName();
    }

    private MoveInnerToTopRefactoring getMoveRefactoring() {
        return (MoveInnerToTopRefactoring)this.getRefactoring();
    }

    private static class MoveInnerToToplnputPage
    extends TextInputWizardPage {
        private final boolean fIsInitialInputValid;
        private static final String DESCRIPTION = RefactoringMessages.getString("MoveInnerToToplnputPage.description");
        private Button fCreateFieldCheckBox;
        private Button fFinalCheckBox;
        private Label fFieldNameLabel;
        private Text fFieldNameEntryText;

        public MoveInnerToToplnputPage(String initialValue) {
            super(DESCRIPTION, true, initialValue);
            this.fIsInitialInputValid = !"".equals(initialValue);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite newControl = new Composite(parent, 0);
            this.setControl((Control)newControl);
            WorkbenchHelp.setHelp((Control)newControl, (String)"org.eclipse.jdt.ui.move_inner_to_top_wizard_page_context");
            newControl.setLayout((Layout)new GridLayout());
            Dialog.applyDialogFont((Control)newControl);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            newControl.setLayout((Layout)layout);
            int indentSize = this.convertWidthInCharsToPixels(3);
            this.addCreateFieldCheckBox(newControl);
            this.addFinalCheckBox(newControl, indentSize);
            this.addFieldNameEntry(newControl, indentSize);
            this.fCreateFieldCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MoveInnerToToplnputPage this$1;
                {
                    this.this$1 = moveInnerToToplnputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveInnerToToplnputPage.access$4(this.this$1, MoveInnerToToplnputPage.access$0(this.this$1), MoveInnerToToplnputPage.access$1(this.this$1), MoveInnerToToplnputPage.access$2(this.this$1), MoveInnerToToplnputPage.access$3(this.this$1));
                    MoveInnerToToplnputPage.access$5(this.this$1).setCreateInstanceField(MoveInnerToToplnputPage.access$0(this.this$1).getSelection());
                }
            });
            this.updateControlEnablement(this.fCreateFieldCheckBox, this.fFinalCheckBox, this.fFieldNameLabel, this.fFieldNameEntryText);
        }

        private void addFieldNameEntry(Composite newControl, int indentSize) {
            this.fFieldNameLabel = new Label(newControl, 0);
            this.fFieldNameLabel.setText(RefactoringMessages.getString("MoveInnerToToplnputPage.enter_name"));
            GridData gd1 = new GridData();
            gd1.horizontalIndent = indentSize;
            this.fFieldNameLabel.setLayoutData((Object)gd1);
            this.fFieldNameEntryText = this.createTextInputField(newControl);
            this.fFieldNameEntryText.selectAll();
            this.fFieldNameEntryText.setLayoutData((Object)new GridData(768));
        }

        private void addFinalCheckBox(Composite newControl, int indentSize) {
            this.fFinalCheckBox = new Button(newControl, 32);
            this.fFinalCheckBox.setText(RefactoringMessages.getString("MoveInnerToToplnputPage.instance_final"));
            this.fFinalCheckBox.setSelection(this.getMoveRefactoring().isInstanceFieldMarkedFinal());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalIndent = indentSize;
            this.fFinalCheckBox.setLayoutData((Object)gd);
            this.fFinalCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MoveInnerToToplnputPage this$1;
                {
                    this.this$1 = moveInnerToToplnputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveInnerToToplnputPage.access$5(this.this$1).setMarkInstanceFieldAsFinal(MoveInnerToToplnputPage.access$1(this.this$1).getSelection());
                }
            });
        }

        private void addCreateFieldCheckBox(Composite newControl) {
            this.fCreateFieldCheckBox = new Button(newControl, 32);
            this.fCreateFieldCheckBox.setText(RefactoringMessages.getString("MoveInnerToToplnputPage.create_field"));
            Assert.isTrue(this.getMoveRefactoring().isCreatingInstanceFieldPossible());
            this.fCreateFieldCheckBox.setEnabled(!this.getMoveRefactoring().isCreatingInstanceFieldMandatory());
            this.fCreateFieldCheckBox.setSelection(this.getMoveRefactoring().getCreateInstanceField());
            GridData gd0 = new GridData(768);
            gd0.horizontalSpan = 2;
            this.fCreateFieldCheckBox.setLayoutData((Object)gd0);
        }

        private void updateControlEnablement(Button createFieldCheckBox, Button finalCheckBox, Label label, Text text) {
            boolean selected = createFieldCheckBox.getSelection();
            finalCheckBox.setEnabled(selected);
            label.setEnabled(selected);
            text.setEnabled(selected);
        }

        protected RefactoringStatus validateTextField(String text) {
            this.getMoveRefactoring().setEnclosingInstanceName(text);
            return this.getMoveRefactoring().checkEnclosingInstanceName(text);
        }

        protected boolean isInitialInputValid() {
            return this.fIsInitialInputValid;
        }

        private MoveInnerToTopRefactoring getMoveRefactoring() {
            return (MoveInnerToTopRefactoring)this.getRefactoring();
        }

        static /* synthetic */ Button access$0(MoveInnerToToplnputPage moveInnerToToplnputPage) {
            return moveInnerToToplnputPage.fCreateFieldCheckBox;
        }

        static /* synthetic */ Button access$1(MoveInnerToToplnputPage moveInnerToToplnputPage) {
            return moveInnerToToplnputPage.fFinalCheckBox;
        }

        static /* synthetic */ Label access$2(MoveInnerToToplnputPage moveInnerToToplnputPage) {
            return moveInnerToToplnputPage.fFieldNameLabel;
        }

        static /* synthetic */ Text access$3(MoveInnerToToplnputPage moveInnerToToplnputPage) {
            return moveInnerToToplnputPage.fFieldNameEntryText;
        }

        static /* synthetic */ void access$4(MoveInnerToToplnputPage moveInnerToToplnputPage, Button button, Button button2, Label label, Text text) {
            moveInnerToToplnputPage.updateControlEnablement(button, button2, label, text);
        }

        static /* synthetic */ MoveInnerToTopRefactoring access$5(MoveInnerToToplnputPage moveInnerToToplnputPage) {
            return moveInnerToToplnputPage.getMoveRefactoring();
        }
    }
}

