/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.SourceContextViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JavaStatusContextViewer
extends SourceContextViewer {
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getSourceViewer().configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools(), null));
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        return new JavaSourceViewer(parent, null, null, false, 66306);
    }

    public void setInput(Context context) {
        if (context instanceof JavaStatusContext) {
            JavaStatusContext jsc = (JavaStatusContext)context;
            IDocument document = null;
            if (jsc.isBinary()) {
                InternalClassFileEditorInput editorInput = new InternalClassFileEditorInput(jsc.getClassFile());
                document = this.getDocument((IDocumentProvider)JavaPlugin.getDefault().getClassFileDocumentProvider(), editorInput);
            } else {
                ICompilationUnit cunit = jsc.getCompilationUnit();
                if (cunit.isWorkingCopy()) {
                    try {
                        document = this.newJavaDocument(cunit.getSource());
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    FileEditorInput editorInput = new FileEditorInput((IFile)cunit.getResource());
                    document = this.getDocument(JavaPlugin.getDefault().getCompilationUnitDocumentProvider(), (IEditorInput)editorInput);
                }
            }
            this.setInput(document, jsc.getSourceRange());
        } else if (context instanceof JavaStringStatusContext) {
            JavaStringStatusContext sc = (JavaStringStatusContext)context;
            this.setInput(this.newJavaDocument(sc.getSource()), sc.getSourceRange());
        }
    }

    private IDocument newJavaDocument(String source) {
        Document result = new Document(source);
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        textTools.setupJavaDocumentPartitioner((IDocument)result);
        return result;
    }
}

