/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.AbstractDescriptor;

public abstract class DescriptorManager {
    private String fExtensionPoint;
    private AbstractDescriptor[] fExtensions;

    public DescriptorManager(String extensionPoint) {
        this.fExtensionPoint = extensionPoint;
    }

    public AbstractDescriptor getDescriptor(Object element) throws CoreException {
        if (this.fExtensions == null) {
            this.init();
        }
        ArrayList<AbstractDescriptor> candidates = new ArrayList<AbstractDescriptor>(1);
        int i = 0;
        while (i < this.fExtensions.length) {
            AbstractDescriptor descriptor = this.fExtensions[i];
            if (descriptor.matches(element)) {
                candidates.add(descriptor);
            }
            descriptor.clear();
            ++i;
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (AbstractDescriptor)candidates.get(0);
        }
        Assert.isTrue(false, "Not support for conflict resolution yet");
        return null;
    }

    protected abstract AbstractDescriptor createDescriptor(IConfigurationElement var1);

    private void init() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), this.fExtensionPoint);
        this.fExtensions = new AbstractDescriptor[ces.length];
        int i = 0;
        while (i < ces.length) {
            this.fExtensions[i] = this.createDescriptor(ces[i]);
            ++i;
        }
    }
}

