/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.jdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.jface.util.Assert;

class DefaultChangeElement
extends ChangeElement {
    private IChange fChange;
    private ChangeElement[] fChildren;

    public DefaultChangeElement(ChangeElement parent, IChange change) {
        super(parent);
        this.fChange = change;
        Assert.isNotNull((Object)this.fChange);
    }

    public IChange getChange() {
        return this.fChange;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewer() throws CoreException {
        return ChangePreviewViewerDescriptor.get(this.fChange);
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        viewer.setInput(this.fChange);
    }

    public void setActive(boolean active) {
        this.fChange.setActive(active);
    }

    public int getActive() {
        if (this.fChange instanceof ICompositeChange || this.fChange instanceof CompilationUnitChange || this.fChange instanceof TextChange) {
            return this.getCompositeChangeActive();
        }
        return this.getDefaultChangeActive();
    }

    public ChangeElement[] getChildren() {
        return this.fChildren;
    }

    public void setChildren(ChangeElement[] children) {
        Assert.isNotNull((Object)children);
        this.fChildren = children;
    }

    private int getDefaultChangeActive() {
        int result;
        int n = result = this.fChange.isActive() ? 2 : 0;
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = ChangeElement.ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
        }
        return result;
    }

    private int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int result = this.fChildren[0].getActive();
            int i = 1;
            while (i < this.fChildren.length) {
                result = ChangeElement.ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
            return result;
        }
        return 2;
    }
}

