/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.jdt.internal.ui.refactoring.IPreviewViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class ComparePreviewer
extends CompareViewerSwitchingPane
implements IPreviewViewer {
    public static final String JAVA_TYPE = "java";
    public static final String TEXT_TYPE = "txt";
    private CompareConfiguration fCompareConfiguration = new CompareConfiguration();
    private ChangeElementLabelProvider fLabelProvider;
    private CompareInput fCompareInput;

    public ComparePreviewer(Composite parent) {
        super(parent, 0x800800, true);
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setLeftLabel(RefactoringMessages.getString("ComparePreviewer.original_source"));
        this.fCompareConfiguration.setRightEditable(false);
        this.fCompareConfiguration.setRightLabel(RefactoringMessages.getString("ComparePreviewer.refactored_source"));
        this.fLabelProvider = new ChangeElementLabelProvider(2304);
    }

    public Control getControl() {
        return this;
    }

    public void refresh() {
        this.getViewer().refresh();
    }

    protected Viewer getViewer(Viewer oldViewer, Object input) {
        return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)this.fCompareConfiguration);
    }

    public void setInput(Object input) {
        if (input instanceof CompareInput) {
            this.fCompareInput = (CompareInput)input;
            super.setInput((Object)new DiffNode((ITypedElement)new CompareElement(this.fCompareInput.left, this.fCompareInput.type), (ITypedElement)new CompareElement(this.fCompareInput.right, this.fCompareInput.type)));
        } else {
            this.fCompareInput = null;
            super.setInput(input);
        }
    }

    public void setText(String text) {
        if (this.fCompareInput == null) {
            super.setText(text);
            this.setImage(null);
            return;
        }
        this.setImage(this.fLabelProvider.getImage(this.fCompareInput.element));
        super.setText(this.fLabelProvider.getText(this.fCompareInput.element));
    }

    public static class CompareInput {
        public InputStream left;
        public InputStream right;
        public String type;
        public ChangeElement element;

        public CompareInput(ChangeElement e, String l, String r, String t) {
            this(e, CompareInput.createInputStream(l), CompareInput.createInputStream(r), t);
        }

        public CompareInput(ChangeElement e, InputStream l, InputStream r, String t) {
            Assert.isNotNull((Object)e);
            Assert.isNotNull((Object)l);
            Assert.isNotNull((Object)r);
            Assert.isNotNull((Object)t);
            this.element = e;
            this.left = l;
            this.right = r;
            this.type = t;
        }

        private static InputStream createInputStream(String s) {
            try {
                return new ByteArrayInputStream(s.getBytes(ResourcesPlugin.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(s.getBytes());
            }
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IStreamContentAccessor {
        private InputStream fContent;
        private String fType;

        public CompareElement(InputStream content, String type) {
            this.fContent = content;
            this.fType = type;
        }

        public String getName() {
            return RefactoringMessages.getString("ComparePreviewer.element_name");
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            return this.fContent;
        }
    }
}

