/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.ChangeExceptionsControl;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IExceptionListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.VisibilityControlUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ChangeSignatureWizard
extends RefactoringWizard {
    public ChangeSignatureWizard(ChangeSignatureRefactoring ref) {
        super(ref, RefactoringMessages.getString("ChangeSignatureRefactoring.modify_Parameters"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeSignatureInputPage());
    }

    private static class ChangeSignatureInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeSignatureInputPage";
        private JavaSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;

        public ChangeSignatureInputPage() {
            super(PAGE_NAME, true);
            this.setMessage(RefactoringMessages.getString("ChangeSignatureInputPage.change"));
            this.fSignaturePreviewDocument = new Document();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.initializeDialogUnits((Control)composite);
            try {
                int[] availableVisibilities = this.getChangeMethodSignatureRefactoring().getAvailableVisibilities();
                int currectVisibility = this.getChangeMethodSignatureRefactoring().getVisibility();
                IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(this){
                    final /* synthetic */ ChangeSignatureInputPage this$1;
                    {
                        this.this$1 = changeSignatureInputPage;
                    }

                    public void visibilityChanged(int newVisibility) {
                        ChangeSignatureInputPage.access$0(this.this$1).setVisibility(newVisibility);
                        ChangeSignatureInputPage.access$1(this.this$1, true);
                    }

                    public void modifierChanged(int modifier, boolean isChecked) {
                    }
                };
                Composite visibilityComposite = VisibilityControlUtil.createVisibilityControl(composite, visibilityChangeListener, availableVisibilities, currectVisibility);
                if (visibilityComposite != null) {
                    visibilityComposite.setLayoutData((Object)new GridData(768));
                }
                if (this.getChangeMethodSignatureRefactoring().canChangeReturnType()) {
                    this.createReturnTypeControl(composite);
                }
                this.createParameterExceptionsFolder(composite);
                Label sep = new Label(composite, 258);
                sep.setLayoutData((Object)new GridData(768));
                this.createSignaturePreview(composite);
                this.update(false);
                this.setControl((Control)composite);
                Dialog.applyDialogFont((Control)composite);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ChangeSignatureInputPage.Change_Signature"), RefactoringMessages.getString("ChangeSignatureInputPage.Internal_Error"));
            }
            WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.modify_parameters_wizard_page_context");
        }

        private void createReturnTypeControl(Composite parent) throws JavaModelException {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.getString("ChangeSignatureInputPage.return_type"));
            label.setLayoutData((Object)new GridData());
            Text text = new Text(composite, 2048);
            text.setText(this.getChangeMethodSignatureRefactoring().getReturnTypeString());
            text.setLayoutData((Object)new GridData(768));
            text.addModifyListener(new ModifyListener(this, text){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = changeSignatureInputPage;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent e) {
                    ChangeSignatureInputPage.access$0(this.this$1).setNewReturnTypeName(this.val$text.getText());
                    ChangeSignatureInputPage.access$1(this.this$1, true);
                }
            });
        }

        private void createParameterExceptionsFolder(Composite composite) {
            TabFolder folder = new TabFolder(composite, 128);
            folder.setLayoutData((Object)new GridData(1808));
            TabItem item = new TabItem(folder, 0);
            item.setText(RefactoringMessages.getString("ChangeSignatureInputPage.parameters"));
            item.setControl(this.createParameterTableControl((Composite)folder));
            TabItem itemEx = new TabItem(folder, 0);
            itemEx.setText(RefactoringMessages.getString("ChangeSignatureInputPage.exceptions"));
            itemEx.setControl(this.createExceptionsTableControl((Composite)folder));
            folder.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    ((TabItem)e.item).getControl().setFocus();
                }
            });
        }

        private Control createParameterTableControl(Composite composite) {
            String labelText = null;
            ChangeParametersControl cp = new ChangeParametersControl(composite, 0, labelText, new IParameterListChangeListener(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void parameterChanged(ParameterInfo parameter) {
                    ChangeSignatureInputPage.access$1(this.this$1, true);
                }

                public void parameterListChanged() {
                    ChangeSignatureInputPage.access$1(this.this$1, true);
                }

                public void parameterAdded(ParameterInfo parameter) {
                    ChangeSignatureInputPage.access$1(this.this$1, true);
                }
            }, true, true, true);
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getChangeMethodSignatureRefactoring().getParameterInfos());
            return cp;
        }

        private Control createExceptionsTableControl(Composite parent) {
            ChangeExceptionsControl cp = new ChangeExceptionsControl(parent, 0, new IExceptionListChangeListener(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void exceptionListChanged() {
                    ChangeSignatureInputPage.access$1(this.this$1, true);
                }
            }, this.getChangeMethodSignatureRefactoring().getMethod().getJavaProject());
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getChangeMethodSignatureRefactoring().getExceptionInfos());
            return cp;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.getString("ChangeSignatureInputPage.method_Signature_Preview"));
            this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584);
            this.fSignaturePreview.configure(new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools(), null));
            this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control signaturePreviewControl = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
            GridData gdata = new GridData(1808);
            gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            signaturePreviewControl.setLayoutData((Object)gdata);
        }

        private ChangeSignatureRefactoring getChangeMethodSignatureRefactoring() {
            return (ChangeSignatureRefactoring)this.getRefactoring();
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            try {
                if (this.getChangeMethodSignatureRefactoring().isSignatureSameAsInitial()) {
                    this.setErrorMessage(null);
                    this.setPageComplete(false);
                    return;
                }
                RefactoringStatus nameCheck = this.getChangeMethodSignatureRefactoring().checkSignature();
                if (nameCheck.hasFatalError()) {
                    if (displayErrorMessage) {
                        this.setErrorMessage(nameCheck.getFirstMessage(4));
                    }
                    this.setPageComplete(false);
                } else {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
            catch (JavaModelException e) {
                this.setErrorMessage(RefactoringMessages.getString("ChangeSignatureInputPage.Internal_Error"));
                this.setPageComplete(false);
                JavaPlugin.log(e);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.getChangeMethodSignatureRefactoring().getMethodSignaturePreview());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ChangeSignatureRefactoring.modify_Parameters"), RefactoringMessages.getString("ChangeSignatureInputPage.exception"));
            }
        }

        static /* synthetic */ ChangeSignatureRefactoring access$0(ChangeSignatureInputPage changeSignatureInputPage) {
            return changeSignatureInputPage.getChangeMethodSignatureRefactoring();
        }

        static /* synthetic */ void access$1(ChangeSignatureInputPage changeSignatureInputPage, boolean bl) {
            changeSignatureInputPage.update(bl);
        }
    }
}

