/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ChangeElementContentProvider
implements ITreeContentProvider {
    private static final ChangeElement[] EMPTY_CHILDREN = new ChangeElement[0];

    ChangeElementContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object o) {
        ChangeElement element = (ChangeElement)o;
        Object[] children = element.getChildren();
        if (children == null) {
            children = this.createChildren(element);
        }
        return children;
    }

    public Object getParent(Object element) {
        return ((ChangeElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    private ChangeElement[] createChildren(ChangeElement object) {
        ChangeElement[] result = EMPTY_CHILDREN;
        if (!(object instanceof DefaultChangeElement)) {
            return result;
        }
        DefaultChangeElement changeElement = (DefaultChangeElement)object;
        IChange change = changeElement.getChange();
        if (change instanceof ICompositeChange) {
            IChange[] children = ((ICompositeChange)change).getChildren();
            result = new ChangeElement[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new DefaultChangeElement(changeElement, children[i]);
                ++i;
            }
        } else if (change instanceof CompilationUnitChange) {
            ArrayList<TextEditChangeElement> children = new ArrayList<TextEditChangeElement>(5);
            CompilationUnitChange cunitChange = (CompilationUnitChange)change;
            ICompilationUnit cunit = cunitChange.getCompilationUnit();
            HashMap map = new HashMap(20);
            TextChange.EditChange[] changes = this.getSortedTextEditChanges(cunitChange);
            int i = 0;
            while (i < changes.length) {
                TextChange.EditChange tec = changes[i];
                try {
                    IJavaElement element = this.getModifiedJavaElement(tec, cunit);
                    if (element.equals(cunit)) {
                        children.add(new TextEditChangeElement(changeElement, tec));
                    } else {
                        PseudoJavaChangeElement pjce = this.getChangeElement(map, element, children, changeElement);
                        pjce.addChild(new TextEditChangeElement(pjce, tec));
                    }
                }
                catch (JavaModelException javaModelException) {
                    children.add(new TextEditChangeElement(changeElement, tec));
                }
                ++i;
            }
            result = children.toArray(new ChangeElement[children.size()]);
        } else if (change instanceof TextChange) {
            TextChange.EditChange[] changes = this.getSortedTextEditChanges((TextChange)change);
            result = new ChangeElement[changes.length];
            int i = 0;
            while (i < changes.length) {
                result[i] = new TextEditChangeElement(changeElement, changes[i]);
                ++i;
            }
        }
        changeElement.setChildren(result);
        return result;
    }

    private TextChange.EditChange[] getSortedTextEditChanges(TextChange change) {
        TextChange.EditChange[] edits = change.getTextEditChanges();
        ArrayList<TextChange.EditChange> result = new ArrayList<TextChange.EditChange>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextChange.EditChange[result.size()]);
    }

    private PseudoJavaChangeElement getChangeElement(Map map, IJavaElement element, List children, ChangeElement cunitChange) {
        PseudoJavaChangeElement result = (PseudoJavaChangeElement)map.get(element);
        if (result != null) {
            return result;
        }
        IJavaElement parent = element.getParent();
        if (parent instanceof ICompilationUnit) {
            result = new PseudoJavaChangeElement(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            PseudoJavaChangeElement parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new PseudoJavaChangeElement(parentChange, element);
            parentChange.addChild(result);
            map.put(element, result);
        }
        return result;
    }

    private IJavaElement getModifiedJavaElement(TextChange.EditChange edit, ICompilationUnit cunit) throws JavaModelException {
        IRegion range = edit.getTextRange();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IJavaElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !edit.coveredBy((IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private static class OffsetComparator
    implements Comparator {
        OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextChange.EditChange c1 = (TextChange.EditChange)o1;
            TextChange.EditChange c2 = (TextChange.EditChange)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextChange.EditChange edit) {
            return edit.getTextRange().getOffset();
        }
    }
}

