/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionParser;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.VariablePool;
import org.eclipse.jface.util.Assert;

public abstract class AbstractDescriptor {
    protected IConfigurationElement fConfigurationElement;
    protected Expression fExpression;
    protected static final String ID = "id";
    protected static final String OBJECT_STATE = "objectState";
    protected static final String CLASS = "class";

    protected AbstractDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public String getId() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public boolean matches(Object element) throws CoreException {
        Expression exp = this.getExpression();
        return exp.evaluate(new VariablePool(null, element)) != TestResult.FALSE;
    }

    public Expression getExpression() throws CoreException {
        if (this.fExpression == null) {
            this.fExpression = this.createExpression(this.fConfigurationElement);
        }
        return this.fExpression;
    }

    public void clear() {
        this.fExpression = null;
    }

    protected Expression createExpression(IConfigurationElement element) throws CoreException {
        IConfigurationElement[] children = element.getChildren("enablement");
        if (children.length == 0) {
            return Expression.FALSE;
        }
        Assert.isTrue((children.length == 1 ? 1 : 0) != 0);
        return ExpressionParser.getStandard().parse(children[0]);
    }
}

