/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProfileManager
extends Observable {
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private final String PROFILE_KEY = "formatter_profile";
    public static final String DEFAULT_PROFILE = "org.eclipse.jdt.ui.default_profile";
    public static final String JAVA_PROFILE = "org.eclipse.jdt.ui.default.sun_profile";
    protected final Map fProfiles;
    protected final List fProfilesByName;
    protected Profile fSelected;
    protected final List fUIKeys = this.getUIKeys();
    protected final List fCoreKeys = this.getCoreKeys();

    public ProfileManager(Collection profiles) {
        this.fProfiles = new HashMap();
        this.fProfilesByName = new ArrayList();
        this.addBuiltinProfiles(this.fProfiles, this.fProfilesByName);
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            CustomProfile profile = (CustomProfile)iter.next();
            profile.setManager(this);
            this.fProfiles.put(profile.getID(), profile);
            this.fProfilesByName.add(profile);
        }
        Collections.sort(this.fProfilesByName);
        String id = ProfileManager.getUIPreferenceStore().getString("formatter_profile");
        this.fSelected = (Profile)this.fProfiles.get(id);
        if (this.fSelected == null) {
            this.fSelected = (Profile)this.fProfiles.get(DEFAULT_PROFILE);
        }
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    private void writeToPreferenceStore(Profile profile) {
        Hashtable actualOptions = JavaCore.getOptions();
        Map profileOptions = profile.getSettings();
        boolean hasChanges = false;
        Iterator keyIter = this.fCoreKeys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String oldVal = (String)actualOptions.get(key);
            String val = (String)profileOptions.get(key);
            if (val.equals(oldVal)) continue;
            hasChanges = true;
            actualOptions.put(key, val);
        }
        if (hasChanges) {
            JavaCore.setOptions((Hashtable)actualOptions);
        }
        new CommentFormattingContext().mapToStore(profile.getSettings(), ProfileManager.getUIPreferenceStore());
        String oldProfile = ProfileManager.getUIPreferenceStore().getString("formatter_profile");
        if (!profile.getID().equals(oldProfile)) {
            ProfileManager.getUIPreferenceStore().setValue("formatter_profile", profile.getID());
        }
    }

    private void addBuiltinProfiles(Map profiles, List profilesByName) {
        BuiltInProfile defaultProfile = new BuiltInProfile(DEFAULT_PROFILE, "Default [built-in]", ProfileManager.getDefaultSettings());
        profiles.put(((Profile)defaultProfile).getID(), defaultProfile);
        profilesByName.add(defaultProfile);
        BuiltInProfile javaProfile = new BuiltInProfile(JAVA_PROFILE, "Java Conventions [built-in]", ProfileManager.getJavaSettings());
        profiles.put(((Profile)javaProfile).getID(), javaProfile);
        profilesByName.add(javaProfile);
    }

    public static Map getDefaultSettings() {
        Map options = DefaultCodeFormatterConstants.getDefaultSettings();
        new CommentFormattingContext().storeToMap(ProfileManager.getUIPreferenceStore(), options, true);
        return options;
    }

    public static Map getJavaSettings() {
        Map options = DefaultCodeFormatterOptions.getJavaConventionsSettings().getMap();
        new CommentFormattingContext().storeToMap(ProfileManager.getUIPreferenceStore(), options, true);
        return options;
    }

    private List getCoreKeys() {
        return new ArrayList(DefaultCodeFormatterConstants.getDefaultSettings().keySet());
    }

    private List getUIKeys() {
        return Arrays.asList(new CommentFormattingContext().getPreferenceKeys());
    }

    public List getSortedProfiles() {
        return new ArrayList(this.fProfilesByName);
    }

    public String[] getSortedNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            sortedNames[i++] = ((Profile)iter.next()).getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return (Profile)this.fProfiles.get(ID);
    }

    public void commitChanges() {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected);
        }
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = (Profile)this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        return this.fProfiles.containsKey(ID_PREFIX + name);
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            oldProfile.remove();
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        int index = this.fProfilesByName.indexOf(this.fSelected);
        ((CustomProfile)this.fSelected).remove();
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(index);
        this.notifyObservers(2);
        return true;
    }

    public static IPreferenceStore getUIPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract void setName(String var1);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public abstract String getID();

        public final int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
    }

    public static class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;

        protected BuiltInProfile(String ID, String name, Map settings) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
        }

        public String getID() {
            return this.fID;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        private ProfileManager fManager;

        public CustomProfile(String name, Map settings) {
            this.fName = name;
            this.fSettings = settings;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            if (this.fManager != null) {
                this.fManager.fProfiles.remove(oldID);
                this.fManager.fProfiles.put(this.getID(), this);
                Collections.sort(this.fManager.fProfilesByName);
                this.notifyObservers(3);
            }
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            this.notifyObservers(5);
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        private void notifyObservers(int message) {
            if (this.fManager != null) {
                this.fManager.notifyObservers(message);
            }
        }

        public void remove() {
            if (this.fManager != null) {
                this.fManager.fProfiles.remove(this.getID());
                this.fManager.fProfilesByName.remove(this);
                this.fManager = null;
            }
        }
    }
}

