/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ModifyDialogTabPage {
    protected final Observer fUpdater = new Observer(){

        public void update(Observable o, Object arg) {
            ModifyDialogTabPage.this.updatePreview();
        }
    };
    protected static String[] falseTrue = new String[]{"false", "true"};
    protected PixelConverter fPixelConverter;
    protected final JavaPreview fJavaPreview;
    protected final Map fWorkingValues;

    public ModifyDialogTabPage(Map workingValues) {
        this.fWorkingValues = workingValues;
        this.fJavaPreview = new JavaPreview(this.fWorkingValues);
    }

    public final Composite createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite page = new Composite(parent, 0);
        GridLayout pageLayout = ModifyDialogTabPage.createGridLayout(2, true);
        pageLayout.horizontalSpacing = 12;
        page.setLayout((Layout)pageLayout);
        Composite settingsPane = this.doCreatePreferences(page);
        settingsPane.setParent(page);
        GridData gd = new GridData(1296);
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        settingsPane.setLayoutData((Object)gd);
        Composite previewPane = this.doCreatePreview(page);
        previewPane.setParent(page);
        gd = new GridData(1808);
        previewPane.setLayoutData((Object)gd);
        this.doInitializeControls();
        return page;
    }

    protected abstract Composite doCreatePreferences(Composite var1);

    protected void doInitializeControls() {
    }

    protected Composite doCreatePreview(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ModifyDialogTabPage.createGridLayout(4, false));
        ModifyDialogTabPage.createLabel(4, composite, "Pre&view:");
        Control control = this.fJavaPreview.createContents(composite);
        GridData gd = ModifyDialogTabPage.createGridData(4, 1808);
        gd.widthHint = 0;
        gd.heightHint = 0;
        control.setLayoutData((Object)gd);
        return composite;
    }

    protected void updatePreview() {
        this.fJavaPreview.update();
    }

    protected static GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        if (margins) {
            layout.marginHeight = 7;
            layout.marginWidth = 7;
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns) {
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        return gd;
    }

    protected static GridData createGridData(int numColumns, int style) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        return gd;
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return ModifyDialogTabPage.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setText(text);
        label.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, gridDataStyle));
        return label;
    }

    protected static Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768));
        group.setLayout((Layout)ModifyDialogTabPage.createGridLayout(numColumns, true));
        group.setText(text);
        return group;
    }

    protected NumberPreference createNumberPref(Composite composite, int numColumns, String name, String key, int minValue, int maxValue) {
        NumberPreference numPref = new NumberPreference(composite, numColumns, this.fWorkingValues, key, minValue, maxValue, name);
        numPref.addObserver(this.fUpdater);
        return numPref;
    }

    protected ComboPreference createComboPref(Composite composite, int numColumns, String name, String key, String[] values, String[] items) {
        ComboPreference comboPref = new ComboPreference(composite, numColumns, this.fWorkingValues, key, values, name, items);
        comboPref.addObserver(this.fUpdater);
        return comboPref;
    }

    protected CheckboxPreference createCheckboxPref(Composite composite, int numColumns, String name, String key, String[] values) {
        CheckboxPreference cp = new CheckboxPreference(composite, numColumns, this.fWorkingValues, key, values, name);
        cp.addObserver(this.fUpdater);
        return cp;
    }

    protected static String createPreviewHeader(String title) {
        return "/**\n* " + title + "\n*/\n\n";
    }

    protected static class CheckboxPreference
    extends Observable {
        private final Map fPreferences;
        private String fKey;
        private boolean fEnabled = true;
        private final String[] fValues;
        private final Button fCheckbox;

        public CheckboxPreference(Composite composite, int numColumns, Map preferences, String key, String[] values, String text) {
            this.fPreferences = preferences;
            this.fCheckbox = new Button(composite, 32);
            this.fCheckbox.setText(text);
            this.fCheckbox.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768));
            this.fValues = values;
            this.setKey(key);
            this.fCheckbox.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ CheckboxPreference this$1;
                {
                    this.this$1 = checkboxPreference;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.checkboxChecked(((Button)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected void checkboxChecked(boolean state) {
            this.fPreferences.put(this.fKey, state ? this.fValues[1] : this.fValues[0]);
            this.setChanged();
            this.notifyObservers();
        }

        public void setKey(String key) {
            this.fKey = key;
            this.updateWidget();
        }

        protected void updateWidget() {
            if (this.fKey != null) {
                this.fCheckbox.setEnabled(this.fEnabled);
                this.fCheckbox.setSelection(this.getChecked());
            } else {
                this.fCheckbox.setSelection(false);
                this.fCheckbox.setEnabled(false);
            }
        }

        public boolean getChecked() {
            return this.fValues[1].equals(this.fPreferences.get(this.fKey));
        }

        public void setEnabled(boolean enabled) {
            this.fEnabled = enabled;
            this.updateWidget();
        }

        public boolean getEnabled() {
            return this.fEnabled;
        }
    }

    protected static class ComboPreference
    extends Observable {
        private final Map fPreferences;
        private String fKey;
        private final String[] fItems;
        private final String[] fValues;
        private Combo fCombo;

        public ComboPreference(Composite composite, int numColumns, Map preferences, String key, String[] values, String text, String[] items) {
            this.fPreferences = preferences;
            this.fValues = values;
            this.fItems = items;
            ModifyDialogTabPage.createLabel(numColumns - 1, composite, text);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setItems(items);
            this.fCombo.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 256));
            this.setKey(key);
            this.fCombo.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ComboPreference this$1;
                {
                    this.this$1 = comboPreference;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.comboSelected(((Combo)e.widget).getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected void comboSelected(int index) {
            this.fPreferences.put(this.fKey, this.fValues[index]);
            this.setChanged();
            this.notifyObservers(this.fValues[index]);
        }

        public void setKey(String key) {
            this.fKey = key;
            this.updateWidget();
        }

        protected void updateWidget() {
            if (this.fKey != null && this.fPreferences != null && this.fValues != null) {
                this.fCombo.setEnabled(true);
                this.fCombo.setText(this.getSelectedItem());
            } else {
                this.fCombo.setText("");
                this.fCombo.setEnabled(false);
            }
        }

        public String getSelectedItem() {
            String selected = (String)this.fPreferences.get(this.fKey);
            int i = 0;
            while (i < this.fValues.length) {
                if (this.fValues[i].equals(selected)) {
                    return this.fItems[i];
                }
                ++i;
            }
            return "";
        }
    }

    protected static class NumberPreference
    extends Observable {
        protected final Map fPreferences;
        protected final int fMinValue;
        protected final int fMaxValue;
        protected int fSelected;
        protected String fKey;
        protected final Text fNumberText;

        public NumberPreference(Composite composite, int numColumns, Map preferences, String key, int minValue, int maxValue, String text) {
            ModifyDialogTabPage.createLabel(numColumns - 1, composite, text);
            this.fNumberText = new Text(composite, 133124);
            this.fPreferences = preferences;
            this.setKey(key);
            GridData gd = ModifyDialogTabPage.createGridData(1, 128);
            gd.widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(5);
            this.fNumberText.setLayoutData((Object)gd);
            this.fMinValue = minValue;
            this.fMaxValue = maxValue;
            this.fNumberText.addFocusListener(new FocusListener(this){
                final /* synthetic */ NumberPreference this$1;
                {
                    this.this$1 = numberPreference;
                }

                public void focusGained(FocusEvent e) {
                    this.this$1.fNumberText.setSelection(0, this.this$1.fNumberText.getCharCount());
                }

                public void focusLost(FocusEvent e) {
                    String s = (String)this.this$1.fPreferences.get(this.this$1.fKey);
                    this.this$1.fSelected = Integer.parseInt(s);
                    this.this$1.fNumberText.setText(s);
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ NumberPreference this$1;
                {
                    this.this$1 = numberPreference;
                }

                public void modifyText(ModifyEvent e) {
                    int newNumber;
                    try {
                        newNumber = Integer.parseInt(((Text)e.widget).getText());
                    }
                    catch (Exception exception) {
                        return;
                    }
                    this.this$1.numberChanged(newNumber);
                }
            });
        }

        protected void numberChanged(int number) {
            if (number < this.fMinValue) {
                return;
            }
            if (number > this.fMaxValue) {
                return;
            }
            if (number != this.fSelected) {
                this.fSelected = number;
                this.updatePreferences();
                this.updateNumberText();
            }
        }

        protected void updatePreferences() {
            this.fPreferences.put(this.fKey, Integer.toString(this.fSelected));
            this.setChanged();
            this.notifyObservers();
        }

        protected void updateNumberText() {
            try {
                int old = Integer.parseInt(this.fNumberText.getText());
                if (this.fSelected == old) {
                    return;
                }
            }
            catch (Exception exception) {}
            this.fNumberText.setText(Integer.toString(this.fSelected));
        }

        public void setKey(String newKey) {
            if (newKey == this.fKey) {
                return;
            }
            this.fKey = newKey;
            if (this.fKey != null) {
                String s = (String)this.fPreferences.get(this.fKey);
                this.fSelected = Integer.parseInt(s);
                this.fNumberText.setText(s);
                this.fNumberText.setEnabled(true);
            } else {
                this.fNumberText.setEnabled(false);
                this.fNumberText.setText("");
            }
        }
    }
}

