/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.BlankLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.BracesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.CommentsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ControlStatementsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.IndentationTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.LineWrappingTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.NewLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.OtherSettingsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.WhiteSpaceTabPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ModifyDialog
extends Dialog {
    private static final int PREFERRED_WIDTH_CHARS = 150;
    private static final int PREFERRED_HEIGHT_CHARS = 40;
    private final String fTitle;
    private final ProfileManager.Profile fProfile;
    private final Map fWorkingValues;

    protected ModifyDialog(Shell parentShell, ProfileManager.Profile profile) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.fTitle = "Edit profile '" + profile.getName() + "'";
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected void okPressed() {
        this.fProfile.setSettings(this.fWorkingValues);
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        tabFolder.setLayoutData((Object)gd);
        ModifyDialog.addTabPage(tabFolder, "B&races", new BracesTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "In&dentation", new IndentationTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "Wh&ite Space", new WhiteSpaceTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "Bla&nk Lines", new BlankLinesTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "New &Lines", new NewLinesTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "Con&trol Statements", new ControlStatementsTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "Lin&e Wrapping", new LineWrappingTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "Co&mments", new CommentsTabPage(this.fWorkingValues));
        ModifyDialog.addTabPage(tabFolder, "&Other", new OtherSettingsTabPage(this.fWorkingValues));
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem t = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)t.getData();
                page.updatePreview();
            }
        });
        return composite;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        Rectangle displayBounds = shell.getDisplay().getClientArea();
        int preferredWidth = this.convertWidthInCharsToPixels(150);
        int preferredHeight = this.convertHeightInCharsToPixels(40);
        Point shellSize = new Point(preferredWidth, preferredHeight);
        shellSize.x = Math.min(shellSize.x, displayBounds.width);
        shellSize.y = Math.min(shellSize.y, displayBounds.height);
        Point shellLocation = shell.getLocation();
        shellLocation.x = Math.max(0, Math.min(displayBounds.x + displayBounds.width - shellSize.x, shellLocation.x));
        shellLocation.y = Math.max(0, Math.min(displayBounds.y + displayBounds.height - shellSize.y, shellLocation.y));
        shell.setLocation(shellLocation);
        shell.setSize(shellSize);
    }

    private static final void addTabPage(TabFolder tabFolder, String title, ModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        Dialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)tabFolder));
    }
}

