/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension2;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JavaPreview {
    private final JavaTextTools fTextTools = JavaPlugin.getDefault().getJavaTextTools();
    private final JavaSourceViewerConfiguration fViewerConfiguration = new JavaSourceViewerConfiguration(this.fTextTools, null, "___java_partitioning");
    private final Document fPreviewDocument = new Document();
    private SourceViewer fSourceViewer;
    protected Map fWorkingValues;
    private String fPreviewText;

    public JavaPreview(Map workingValues) {
        this.fWorkingValues = workingValues;
        this.fTextTools.setupJavaDocumentPartitioner((IDocument)this.fPreviewDocument, "___java_partitioning");
    }

    public Control createContents(Composite parent) {
        if (this.fSourceViewer != null) {
            return null;
        }
        this.fSourceViewer = new JavaSourceViewer(parent, null, null, false, 2824);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        new JavaSourcePreviewerUpdater(this.fSourceViewer, this.fTextTools);
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
        this.update();
        return this.fSourceViewer.getControl();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() {
        if (this.fWorkingValues == null) {
            return;
        }
        StyledText text = this.fSourceViewer.getTextWidget();
        int top0 = this.fSourceViewer.getTopIndex();
        int range0 = text.getLineCount() - (this.fSourceViewer.getBottomIndex() - this.fSourceViewer.getTopIndex());
        if (this.fPreviewText == null) {
            this.fPreviewDocument.set("");
            this.fSourceViewer.getControl().setEnabled(false);
            return;
        }
        if (!this.fSourceViewer.getControl().getEnabled()) {
            this.fSourceViewer.getControl().setEnabled(true);
        }
        this.fSourceViewer.setRedraw(false);
        this.fSourceViewer.getTextWidget().setTabs(JavaPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.tabulation.size"), 0));
        Point selection = this.fSourceViewer.getSelectedRange();
        this.fPreviewDocument.set(this.fPreviewText);
        CommentFormattingContext context = new CommentFormattingContext();
        try {
            IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
            if (formatter instanceof IContentFormatterExtension2) {
                IContentFormatterExtension2 extension = (IContentFormatterExtension2)formatter;
                context.setProperty("formatting.context.preferences", this.fWorkingValues);
                context.setProperty("formatting.context.document", true);
                extension.format((IDocument)this.fPreviewDocument, (IFormattingContext)context);
            } else {
                formatter.format((IDocument)this.fPreviewDocument, (IRegion)new Region(0, this.fPreviewDocument.getLength()));
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fSourceViewer.setSelectedRange(selection.x, selection.y);
            context.dispose();
            int range1 = text.getLineCount() - (this.fSourceViewer.getBottomIndex() - this.fSourceViewer.getTopIndex());
            this.fSourceViewer.setRedraw(true);
            this.fSourceViewer.setTopIndex((int)Math.round((double)(top0 * range1) / (double)range0));
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.fSourceViewer.setSelectedRange(selection.x, selection.y);
        context.dispose();
        int range1 = text.getLineCount() - (this.fSourceViewer.getBottomIndex() - this.fSourceViewer.getTopIndex());
        this.fSourceViewer.setRedraw(true);
        this.fSourceViewer.setTopIndex((int)Math.round((double)(top0 * range1) / (double)range0));
    }

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public final Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public final void setWorkingValues(Map workingValues) {
        this.fWorkingValues = workingValues;
    }

    public final String getPreviewText() {
        return this.fPreviewText;
    }

    public final void setPreviewText(String previewText) {
        this.fPreviewText = previewText;
    }

    private class JavaSourcePreviewerUpdater {
        public JavaSourcePreviewerUpdater(SourceViewer viewer, JavaTextTools javaTextTools) {
            Assert.isNotNull((Object)viewer);
            Assert.isNotNull((Object)javaTextTools);
            IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(this, viewer){
                final /* synthetic */ JavaSourcePreviewerUpdater this$1;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = javaSourcePreviewerUpdater;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.jdt.ui.editors.textfont")) {
                        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
                        this.val$viewer.getTextWidget().setFont(font);
                    }
                }
            };
            IPreferenceStore preferenceStore = javaTextTools.getPreferenceStore();
            IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(this, javaTextTools, viewer){
                final /* synthetic */ JavaSourcePreviewerUpdater this$1;
                private final /* synthetic */ JavaTextTools val$javaTextTools;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = javaSourcePreviewerUpdater;
                    this.val$javaTextTools = javaTextTools;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent event) {
                    if (this.val$javaTextTools.affectsBehavior(event)) {
                        this.val$viewer.invalidateTextPresentation();
                    }
                }
            };
            viewer.getTextWidget().addDisposeListener(new DisposeListener(this, preferenceStore, propertyChangeListener, fontChangeListener){
                final /* synthetic */ JavaSourcePreviewerUpdater this$1;
                private final /* synthetic */ IPreferenceStore val$preferenceStore;
                private final /* synthetic */ IPropertyChangeListener val$propertyChangeListener;
                private final /* synthetic */ IPropertyChangeListener val$fontChangeListener;
                {
                    this.this$1 = javaSourcePreviewerUpdater;
                    this.val$preferenceStore = iPreferenceStore;
                    this.val$propertyChangeListener = iPropertyChangeListener;
                    this.val$fontChangeListener = iPropertyChangeListener2;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.val$preferenceStore.removePropertyChangeListener(this.val$propertyChangeListener);
                    JFaceResources.getFontRegistry().removeListener(this.val$fontChangeListener);
                }
            });
            JFaceResources.getFontRegistry().addListener(fontChangeListener);
            preferenceStore.addPropertyChangeListener(propertyChangeListener);
        }
    }
}

