/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final ProfileManager fProfileManager;
    private final List fSortedProfiles;
    private final String[] fSortedNames;
    private ProfileManager.CustomProfile fCreatedProfile;
    protected boolean fOpenEditDialog;

    public CreateProfileDialog(Shell parentShell, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedNames();
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, "A profile with this name already exists");
        this.fEmpty = new StatusInfo(4, "Profile name is empty");
    }

    public void create() {
        super.create();
        this.setTitle("New Code Formatter Profile");
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText("Profile name:");
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText("Initialize settings with the following profile:");
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite, 32);
        this.fEditCheckbox.setText("Open the edit dialog now");
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fEditCheckbox.setSelection(true);
        this.fOpenEditDialog = true;
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fProfileManager.getProfile("org.eclipse.jdt.ui.default_profile").getName());
        this.updateStatus(this.fEmpty);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus(this.fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus(this.fEmpty);
            return;
        }
        this.updateStatus(this.fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        HashMap baseSettings = new HashMap(((ProfileManager.Profile)this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex())).getSettings());
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = new ProfileManager.CustomProfile(profileName, baseSettings);
        this.fProfileManager.addProfile(this.fCreatedProfile);
        super.okPressed();
    }

    public final ProfileManager.CustomProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

